/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import org.apache.commons.lang3.ClassUtils;
import org.apache.syncope.core.provisioning.api.job.JobDelegate;
import org.apache.syncope.core.provisioning.api.job.SchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.java.job.AbstractInterruptableJob;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskJob
extends AbstractInterruptableJob {
    private static final Logger LOG = LoggerFactory.getLogger(TaskJob.class);
    public static final String DRY_RUN_JOBDETAIL_KEY = "dryRun";
    public static final String DELEGATE_CLASS_KEY = "delegateClass";
    private String taskKey;
    private SchedTaskJobDelegate delegate;

    public void setTaskKey(String taskKey) {
        this.taskKey = taskKey;
    }

    @Override
    public JobDelegate getDelegate() {
        return this.delegate;
    }

    public void execute(final JobExecutionContext context) throws JobExecutionException {
        try {
            AuthContextUtils.execWithAuthContext((String)context.getMergedJobDataMap().getString("domain"), (AuthContextUtils.Executable)new AuthContextUtils.Executable<Void>(){

                public Void exec() {
                    try {
                        Class delegateClass = ClassUtils.getClass((String)context.getMergedJobDataMap().getString(TaskJob.DELEGATE_CLASS_KEY));
                        TaskJob.this.delegate = (SchedTaskJobDelegate)ApplicationContextProvider.getBeanFactory().createBean(delegateClass, 1, false);
                        TaskJob.this.delegate.execute(TaskJob.this.taskKey, context.getMergedJobDataMap().getBoolean(TaskJob.DRY_RUN_JOBDETAIL_KEY), context);
                    }
                    catch (Exception e) {
                        LOG.error("While executing task {}", (Object)TaskJob.this.taskKey, (Object)e);
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            });
        }
        catch (RuntimeException e) {
            LOG.error("While executing task {}", (Object)this.taskKey, (Object)e);
            throw new JobExecutionException("While executing task " + this.taskKey, (Throwable)e);
        }
    }

    public static enum Status {
        SUCCESS,
        FAILURE;

    }
}

