/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.conf.CPlainAttr;
import org.apache.syncope.core.persistence.api.entity.conf.CPlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.java.job.AbstractSchedTaskJobDelegate;
import org.apache.syncope.core.workflow.api.UserWorkflowAdapter;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class IdentityRecertification
extends AbstractSchedTaskJobDelegate {
    private static final String RECERTIFICATION_TIME = "identity.recertification.day.interval";
    @Autowired
    private ConfDAO confDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private UserWorkflowAdapter uwfAdapter;
    private long recertificationTime = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        IdentityRecertification identityRecertification = this;
        synchronized (identityRecertification) {
            if (this.recertificationTime == -1L) {
                CPlainAttr recertificationTimeAttr = this.confDAO.find(RECERTIFICATION_TIME);
                if (recertificationTimeAttr == null || ((CPlainAttrValue)recertificationTimeAttr.getValues().get(0)).getLongValue() == null) {
                    this.recertificationTime = -1L;
                    return;
                }
                this.recertificationTime = ((CPlainAttrValue)recertificationTimeAttr.getValues().get(0)).getLongValue() * 1000L * 60L * 60L * 24L;
            }
        }
    }

    protected boolean isToBeRecertified(User user, long now) {
        if (!(user.isSuspended().booleanValue() || user.getLastRecertification() != null && user.getLastRecertification().getTime() + this.recertificationTime >= now)) {
            LOG.debug("{} is to be recertified", (Object)user);
            return true;
        }
        LOG.debug("{} does not need to be recertified", (Object)user);
        return false;
    }

    @Override
    protected String doExecute(boolean dryRun) throws JobExecutionException {
        LOG.info("IdentityRecertification {} running [SchedTask {}]", (Object)(dryRun ? "dry " : ""), (Object)this.task.getKey());
        this.init();
        if (this.recertificationTime == -1L) {
            LOG.debug("Identity Recertification disabled");
            return "IDENTITY RECERTIFICATION DISABLED";
        }
        if (dryRun) {
            return "DRY RUN";
        }
        int total = this.userDAO.count();
        int pages = total / 500 + 1;
        this.status.set("Processing " + total + " users in " + pages + " pages");
        long now = System.currentTimeMillis();
        for (int page = 1; page <= pages && !this.interrupt; ++page) {
            this.status.set("Processing " + total + " users: page " + page + " of " + pages);
            List users = this.userDAO.findAll(page, 500);
            for (int i = 0; i < users.size() && !this.interrupt; ++i) {
                LOG.debug("Processing user: {}", (Object)((User)users.get(i)).getUsername());
                if (StringUtils.isNotBlank((CharSequence)((User)users.get(i)).getWorkflowId()) && this.isToBeRecertified((User)users.get(i), now)) {
                    this.uwfAdapter.requestCertify((User)users.get(i));
                    continue;
                }
                LOG.warn("Workflow for {} is null or empty", users.get(i));
            }
        }
        if (this.interrupt) {
            this.interrupted = true;
            return "Identity recertification interrupted";
        }
        return "SUCCESS";
    }

    @Override
    protected boolean hasToBeRegistered(TaskExec execution) {
        return true;
    }
}

