/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.NotificationTaskTO;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.to.ProvisioningTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.JobType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTemplate;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.task.AnyTemplatePullTask;
import org.apache.syncope.core.persistence.api.entity.task.NotificationTask;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTaskAnyFilter;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtils;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.provisioning.api.data.TaskDataBinder;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.provisioning.java.pushpull.PullJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.PushJobDelegate;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.apache.syncope.core.spring.BeanUtils;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Component;

@Component
public class TaskDataBinderImpl
implements TaskDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(TaskDataBinder.class);
    private static final String[] IGNORE_TASK_PROPERTIES = new String[]{"destinationRealm", "templates", "filters", "executions", "resource", "matchingRule", "unmatchingRule", "notification"};
    private static final String[] IGNORE_TASK_EXECUTION_PROPERTIES = new String[]{"key", "task"};
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private TaskExecDAO taskExecDAO;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private TemplateUtils templateUtils;
    @Autowired
    private SchedulerFactoryBean scheduler;
    @Autowired
    private TaskUtilsFactory taskUtilsFactory;

    private void fill(ProvisioningTask task, ProvisioningTaskTO taskTO) {
        if (task instanceof PushTask && taskTO instanceof PushTaskTO) {
            PushTask pushTask = (PushTask)task;
            final PushTaskTO pushTaskTO = (PushTaskTO)taskTO;
            pushTask.setJobDelegateClassName(pushTaskTO.getJobDelegateClassName() == null ? PushJobDelegate.class.getName() : pushTaskTO.getJobDelegateClassName());
            pushTask.setSourceRealm(this.realmDAO.findByFullPath(pushTaskTO.getSourceRealm()));
            pushTask.setMatchingRule(pushTaskTO.getMatchingRule() == null ? MatchingRule.LINK : pushTaskTO.getMatchingRule());
            pushTask.setUnmatchingRule(pushTaskTO.getUnmatchingRule() == null ? UnmatchingRule.ASSIGN : pushTaskTO.getUnmatchingRule());
            for (Map.Entry entry : pushTaskTO.getFilters().entrySet()) {
                AnyType anyType = this.anyTypeDAO.find((String)entry.getKey());
                if (anyType == null) {
                    LOG.debug("Invalid AnyType {} specified, ignoring...", entry.getKey());
                    continue;
                }
                PushTaskAnyFilter filter = pushTask.getFilter(anyType);
                if (filter == null) {
                    filter = (PushTaskAnyFilter)this.entityFactory.newEntity(PushTaskAnyFilter.class);
                    filter.setAnyType(anyType);
                    filter.setPushTask(pushTask);
                    pushTask.add(filter);
                }
                filter.setFIQLCond((String)entry.getValue());
            }
            CollectionUtils.filter((Iterable)pushTask.getFilters(), (Predicate)new Predicate<PushTaskAnyFilter>(){

                public boolean evaluate(PushTaskAnyFilter anyFilter) {
                    return pushTaskTO.getFilters().containsKey(anyFilter.getAnyType().getKey());
                }
            });
        } else if (task instanceof PullTask && taskTO instanceof PullTaskTO) {
            PullTask pullTask = (PullTask)task;
            final PullTaskTO pullTaskTO = (PullTaskTO)taskTO;
            pullTask.setPullMode(pullTaskTO.getPullMode());
            pullTask.setReconciliationFilterBuilderClassName(pullTaskTO.getReconciliationFilterBuilderClassName());
            pullTask.setDestinationRealm(this.realmDAO.findByFullPath(pullTaskTO.getDestinationRealm()));
            pullTask.setJobDelegateClassName(pullTaskTO.getJobDelegateClassName() == null ? PullJobDelegate.class.getName() : pullTaskTO.getJobDelegateClassName());
            pullTask.setMatchingRule(pullTaskTO.getMatchingRule() == null ? MatchingRule.UPDATE : pullTaskTO.getMatchingRule());
            pullTask.setUnmatchingRule(pullTaskTO.getUnmatchingRule() == null ? UnmatchingRule.PROVISION : pullTaskTO.getUnmatchingRule());
            this.templateUtils.check(pullTaskTO.getTemplates(), ClientExceptionType.InvalidPullTask);
            for (Map.Entry entry : pullTaskTO.getTemplates().entrySet()) {
                AnyType type = this.anyTypeDAO.find((String)entry.getKey());
                if (type == null) {
                    LOG.debug("Invalid AnyType {} specified, ignoring...", entry.getKey());
                    continue;
                }
                AnyTemplatePullTask anyTemplate = pullTask.getTemplate(type);
                if (anyTemplate == null) {
                    anyTemplate = (AnyTemplatePullTask)this.entityFactory.newEntity(AnyTemplatePullTask.class);
                    anyTemplate.setAnyType(type);
                    anyTemplate.setPullTask(pullTask);
                    pullTask.add(anyTemplate);
                }
                anyTemplate.set((AnyTO)entry.getValue());
            }
            CollectionUtils.filter((Iterable)pullTask.getTemplates(), (Predicate)new Predicate<AnyTemplate>(){

                public boolean evaluate(AnyTemplate anyTemplate) {
                    return pullTaskTO.getTemplates().containsKey(anyTemplate.getAnyType().getKey());
                }
            });
        }
        task.setPerformCreate(taskTO.isPerformCreate());
        task.setPerformUpdate(taskTO.isPerformUpdate());
        task.setPerformDelete(taskTO.isPerformDelete());
        task.setSyncStatus(taskTO.isSyncStatus());
        task.getActionsClassNames().clear();
        task.getActionsClassNames().addAll(taskTO.getActionsClassNames());
    }

    public SchedTask createSchedTask(SchedTaskTO taskTO, TaskUtils taskUtils) {
        Class taskTOClass = taskUtils.taskTOClass();
        if (taskTOClass == null || !taskTOClass.equals(taskTO.getClass())) {
            throw new IllegalArgumentException(String.format("Expected %s, found %s", taskTOClass, taskTO.getClass()));
        }
        SchedTask task = (SchedTask)taskUtils.newTask();
        task.setStartAt(taskTO.getStartAt());
        task.setCronExpression(taskTO.getCronExpression());
        task.setName(taskTO.getName());
        task.setDescription(taskTO.getDescription());
        task.setActive(taskTO.isActive());
        if (taskUtils.getType() == TaskType.SCHEDULED) {
            task.setJobDelegateClassName(taskTO.getJobDelegateClassName());
        } else if (taskTO instanceof ProvisioningTaskTO) {
            ProvisioningTaskTO provisioningTaskTO = (ProvisioningTaskTO)taskTO;
            ExternalResource resource = this.resourceDAO.find(provisioningTaskTO.getResource());
            if (resource == null) {
                throw new NotFoundException("Resource " + provisioningTaskTO.getResource());
            }
            ((ProvisioningTask)task).setResource(resource);
            this.fill((ProvisioningTask)task, provisioningTaskTO);
        }
        return task;
    }

    public void updateSchedTask(SchedTask task, SchedTaskTO taskTO, TaskUtils taskUtils) {
        Class taskTOClass = taskUtils.taskTOClass();
        if (taskTOClass == null || !taskTOClass.equals(taskTO.getClass())) {
            throw new IllegalArgumentException(String.format("Expected %s, found %s", taskTOClass, taskTO.getClass()));
        }
        if (StringUtils.isBlank((CharSequence)taskTO.getName())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            sce.getElements().add("name");
            throw sce;
        }
        task.setName(taskTO.getName());
        task.setDescription(taskTO.getDescription());
        task.setCronExpression(taskTO.getCronExpression());
        task.setActive(taskTO.isActive());
        if (task instanceof ProvisioningTask) {
            this.fill((ProvisioningTask)task, (ProvisioningTaskTO)taskTO);
        }
    }

    public String buildRefDesc(Task task) {
        return this.taskUtilsFactory.getInstance(task).getType().name() + " Task " + task.getKey() + " " + (task instanceof SchedTask ? ((SchedTask)SchedTask.class.cast(task)).getName() : (task instanceof PropagationTask ? ((PropagationTask)PropagationTask.class.cast(task)).getConnObjectKey() : ""));
    }

    public ExecTO getExecTO(TaskExec execution) {
        ExecTO execTO = new ExecTO();
        BeanUtils.copyProperties((Object)execution, (Object)execTO, (String[])IGNORE_TASK_EXECUTION_PROPERTIES);
        if (execution.getKey() != null) {
            execTO.setKey(execution.getKey());
        }
        if (execution.getTask() != null && execution.getTask().getKey() != null) {
            execTO.setJobType(JobType.TASK);
            execTO.setRefKey(execution.getTask().getKey());
            execTO.setRefDesc(this.buildRefDesc(execution.getTask()));
        }
        return execTO;
    }

    private void setExecTime(SchedTaskTO taskTO, Task task) {
        taskTO.setLastExec(taskTO.getStart());
        String triggerName = JobNamer.getTriggerName((String)JobNamer.getJobKey((Task)task).getName());
        try {
            Trigger trigger = this.scheduler.getScheduler().getTrigger(new TriggerKey(triggerName, "DEFAULT"));
            if (trigger != null) {
                taskTO.setLastExec(trigger.getPreviousFireTime());
                taskTO.setNextExec(trigger.getNextFireTime());
            }
        }
        catch (SchedulerException e) {
            LOG.warn("While trying to get to " + triggerName, (Throwable)e);
        }
    }

    public <T extends TaskTO> T getTaskTO(Task task, TaskUtils taskUtils, boolean details) {
        TaskTO taskTO = taskUtils.newTaskTO();
        BeanUtils.copyProperties((Object)task, (Object)taskTO, (String[])IGNORE_TASK_PROPERTIES);
        TaskExec latestExec = this.taskExecDAO.findLatestStarted(task);
        if (latestExec == null) {
            taskTO.setLatestExecStatus("");
        } else {
            taskTO.setLatestExecStatus(latestExec.getStatus());
            taskTO.setStart(latestExec.getStart());
            taskTO.setEnd(latestExec.getEnd());
        }
        if (details) {
            for (TaskExec execution : task.getExecs()) {
                if (execution == null) continue;
                taskTO.getExecutions().add(this.getExecTO(execution));
            }
        }
        switch (taskUtils.getType()) {
            case PROPAGATION: {
                ((PropagationTaskTO)taskTO).setAnyTypeKind(((PropagationTask)task).getAnyTypeKind());
                ((PropagationTaskTO)taskTO).setEntityKey(((PropagationTask)task).getEntityKey());
                ((PropagationTaskTO)taskTO).setResource(((PropagationTask)task).getResource().getKey());
                ((PropagationTaskTO)taskTO).setAttributes(((PropagationTask)task).getSerializedAttributes());
                break;
            }
            case SCHEDULED: {
                this.setExecTime((SchedTaskTO)taskTO, task);
                break;
            }
            case PULL: {
                this.setExecTime((SchedTaskTO)taskTO, task);
                ((PullTaskTO)taskTO).setDestinationRealm(((PullTask)task).getDestinatioRealm().getFullPath());
                ((PullTaskTO)taskTO).setResource(((PullTask)task).getResource().getKey());
                ((PullTaskTO)taskTO).setMatchingRule(((PullTask)task).getMatchingRule() == null ? MatchingRule.UPDATE : ((PullTask)task).getMatchingRule());
                ((PullTaskTO)taskTO).setUnmatchingRule(((PullTask)task).getUnmatchingRule() == null ? UnmatchingRule.PROVISION : ((PullTask)task).getUnmatchingRule());
                for (AnyTemplate template : ((PullTask)task).getTemplates()) {
                    ((PullTaskTO)taskTO).getTemplates().put(template.getAnyType().getKey(), template.get());
                }
                break;
            }
            case PUSH: {
                this.setExecTime((SchedTaskTO)taskTO, task);
                ((PushTaskTO)taskTO).setSourceRealm(((PushTask)task).getSourceRealm().getFullPath());
                ((PushTaskTO)taskTO).setResource(((PushTask)task).getResource().getKey());
                ((PushTaskTO)taskTO).setMatchingRule(((PushTask)task).getMatchingRule() == null ? MatchingRule.LINK : ((PushTask)task).getMatchingRule());
                ((PushTaskTO)taskTO).setUnmatchingRule(((PushTask)task).getUnmatchingRule() == null ? UnmatchingRule.ASSIGN : ((PushTask)task).getUnmatchingRule());
                for (PushTaskAnyFilter filter : ((PushTask)task).getFilters()) {
                    ((PushTaskTO)taskTO).getFilters().put(filter.getAnyType().getKey(), filter.getFIQLCond());
                }
                break;
            }
            case NOTIFICATION: {
                ((NotificationTaskTO)taskTO).setNotification(((NotificationTask)task).getNotification().getKey());
                ((NotificationTaskTO)taskTO).setAnyTypeKind(((NotificationTask)task).getAnyTypeKind());
                ((NotificationTaskTO)taskTO).setEntityKey(((NotificationTask)task).getEntityKey());
                if (!((NotificationTask)task).isExecuted() || !StringUtils.isBlank((CharSequence)taskTO.getLatestExecStatus())) break;
                taskTO.setLatestExecStatus("[EXECUTED]");
                break;
            }
        }
        return (T)taskTO;
    }
}

