/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.RoleTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.DynRealm;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.user.DynRoleMembership;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.provisioning.api.data.RoleDataBinder;
import org.apache.syncope.core.provisioning.api.utils.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RoleDataBinderImpl
implements RoleDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(RoleDataBinder.class);
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private DynRealmDAO dynRealmDAO;
    @Autowired
    private RoleDAO roleDAO;
    @Autowired
    private EntityFactory entityFactory;

    private void setDynMembership(Role role, String dynMembershipFIQL) {
        DynRoleMembership dynMembership;
        SearchCond dynMembershipCond = SearchCondConverter.convert((String)dynMembershipFIQL, (String[])new String[0]);
        if (!dynMembershipCond.isValid()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchExpression);
            sce.getElements().add(dynMembershipFIQL);
            throw sce;
        }
        if (role.getDynMembership() == null) {
            dynMembership = (DynRoleMembership)this.entityFactory.newEntity(DynRoleMembership.class);
            dynMembership.setRole(role);
            role.setDynMembership(dynMembership);
        } else {
            dynMembership = role.getDynMembership();
        }
        dynMembership.setFIQLCond(dynMembershipFIQL);
    }

    public Role create(RoleTO roleTO) {
        return this.update((Role)this.entityFactory.newEntity(Role.class), roleTO);
    }

    public Role update(Role toBeUpdated, RoleTO roleTO) {
        toBeUpdated.setKey(roleTO.getKey());
        Role role = this.roleDAO.save(toBeUpdated);
        role.getEntitlements().clear();
        role.getEntitlements().addAll(roleTO.getEntitlements());
        role.getRealms().clear();
        for (String realmFullPath : roleTO.getRealms()) {
            Realm realm = this.realmDAO.findByFullPath(realmFullPath);
            if (realm == null) {
                LOG.debug("Invalid realm full path {}, ignoring", (Object)realmFullPath);
                continue;
            }
            role.add(realm);
        }
        role.getDynRealms().clear();
        for (String key : roleTO.getDynRealms()) {
            DynRealm dynRealm = this.dynRealmDAO.find(key);
            if (dynRealm == null) {
                LOG.debug("Invalid dynamic ream {}, ignoring", (Object)key);
                continue;
            }
            role.add(dynRealm);
        }
        role = this.roleDAO.save(role);
        this.roleDAO.clearDynMembers(role);
        if (role.getKey() == null && roleTO.getDynMembershipCond() != null) {
            this.setDynMembership(role, roleTO.getDynMembershipCond());
        } else if (role.getDynMembership() != null && roleTO.getDynMembershipCond() == null) {
            role.setDynMembership(null);
        } else if (role.getDynMembership() == null && roleTO.getDynMembershipCond() != null) {
            this.setDynMembership(role, roleTO.getDynMembershipCond());
        } else if (role.getDynMembership() != null && roleTO.getDynMembershipCond() != null && !role.getDynMembership().getFIQLCond().equals(roleTO.getDynMembershipCond())) {
            this.setDynMembership(role, roleTO.getDynMembershipCond());
        }
        return this.roleDAO.saveAndRefreshDynMemberships(role);
    }

    public RoleTO getRoleTO(Role role) {
        RoleTO roleTO = new RoleTO();
        roleTO.setKey(role.getKey());
        roleTO.getEntitlements().addAll(role.getEntitlements());
        CollectionUtils.collect((Iterable)role.getRealms(), (Transformer)new Transformer<Realm, String>(){

            public String transform(Realm input) {
                return input.getFullPath();
            }
        }, (Collection)roleTO.getRealms());
        CollectionUtils.collect((Iterable)role.getDynRealms(), (Transformer)EntityUtils.keyTransformer(), (Collection)roleTO.getDynRealms());
        if (role.getDynMembership() != null) {
            roleTO.setDynMembershipCond(role.getDynMembership().getFIQLCond());
        }
        return roleTO;
    }
}

