/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.provisioning.api.data.JEXLItemTransformer;
import org.apache.syncope.core.provisioning.java.data.DefaultItemTransformer;
import org.apache.syncope.core.provisioning.java.jexl.JexlUtils;

public class JEXLItemTransformerImpl
extends DefaultItemTransformer
implements JEXLItemTransformer {
    private String propagationJEXL;
    private String pullJEXL;

    public void setPropagationJEXL(String propagationJEXL) {
        this.propagationJEXL = propagationJEXL;
    }

    public void setPullJEXL(String pullJEXL) {
        this.pullJEXL = pullJEXL;
    }

    @Override
    public List<PlainAttrValue> beforePropagation(Item item, Entity entity, List<PlainAttrValue> values) {
        if (StringUtils.isNotBlank((CharSequence)this.propagationJEXL) && values != null) {
            for (PlainAttrValue value : values) {
                MapContext jexlContext = new MapContext();
                if (entity != null) {
                    JexlUtils.addFieldsToContext(entity, (JexlContext)jexlContext);
                    if (entity instanceof Any) {
                        JexlUtils.addPlainAttrsToContext(((Any)entity).getPlainAttrs(), (JexlContext)jexlContext);
                        JexlUtils.addDerAttrsToContext((Any)entity, (JexlContext)jexlContext);
                    }
                }
                jexlContext.set("value", (Object)value.getValueAsString());
                value.setStringValue(JexlUtils.evaluate(this.propagationJEXL, (JexlContext)jexlContext));
            }
            return values;
        }
        return super.beforePropagation(item, entity, values);
    }

    @Override
    public List<Object> beforePull(Item item, EntityTO entityTO, List<Object> values) {
        if (StringUtils.isNotBlank((CharSequence)this.pullJEXL) && values != null) {
            ArrayList<Object> newValues = new ArrayList<Object>(values.size());
            for (Object value : values) {
                MapContext jexlContext = new MapContext();
                jexlContext.set("value", value);
                if (entityTO instanceof AnyTO) {
                    JexlUtils.addFieldsToContext((AnyTO)entityTO, (JexlContext)jexlContext);
                    JexlUtils.addAttrTOsToContext(((AnyTO)entityTO).getPlainAttrs(), (JexlContext)jexlContext);
                    JexlUtils.addAttrTOsToContext(((AnyTO)entityTO).getDerAttrs(), (JexlContext)jexlContext);
                    JexlUtils.addAttrTOsToContext(((AnyTO)entityTO).getVirAttrs(), (JexlContext)jexlContext);
                } else if (entityTO instanceof RealmTO) {
                    JexlUtils.addFieldsToContext((RealmTO)entityTO, (JexlContext)jexlContext);
                }
                newValues.add(JexlUtils.evaluate(this.pullJEXL, (JexlContext)jexlContext));
            }
            return newValues;
        }
        return super.beforePull(item, entityTO, values);
    }
}

