/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ConnInstanceHistoryConfTO;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.ConnPoolConfTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ConnConfPropSchema;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceHistoryConfDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.ConnInstanceHistoryConf;
import org.apache.syncope.core.persistence.api.entity.ConnPoolConf;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.provisioning.api.ConnIdBundleManager;
import org.apache.syncope.core.provisioning.api.data.ConnInstanceDataBinder;
import org.apache.syncope.core.provisioning.api.utils.ConnPoolConfUtils;
import org.apache.syncope.core.spring.BeanUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.api.ConfigurationProperties;
import org.identityconnectors.framework.api.ConfigurationProperty;
import org.identityconnectors.framework.api.ConnectorInfo;
import org.identityconnectors.framework.impl.api.ConfigurationPropertyImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConnInstanceDataBinderImpl
implements ConnInstanceDataBinder {
    private static final String[] IGNORE_PROPERTIES = new String[]{"poolConf", "location", "adminRealm", "conf"};
    @Autowired
    private ConnIdBundleManager connIdBundleManager;
    @Autowired
    private ConnInstanceDAO connInstanceDAO;
    @Autowired
    private ConnInstanceHistoryConfDAO connInstanceHistoryConfDAO;
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private ConfDAO confDAO;
    @Autowired
    private EntityFactory entityFactory;

    public ConnInstance getConnInstance(ConnInstanceTO connInstanceTO) {
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        if (connInstanceTO.getLocation() == null) {
            sce.getElements().add("location");
        }
        if (connInstanceTO.getBundleName() == null) {
            sce.getElements().add("bundlename");
        }
        if (connInstanceTO.getVersion() == null) {
            sce.getElements().add("bundleversion");
        }
        if (connInstanceTO.getConnectorName() == null) {
            sce.getElements().add("connectorname");
        }
        if (connInstanceTO.getConf().isEmpty()) {
            sce.getElements().add("configuration");
        }
        ConnInstance connInstance = (ConnInstance)this.entityFactory.newEntity(ConnInstance.class);
        BeanUtils.copyProperties((Object)connInstanceTO, (Object)connInstance, (String[])IGNORE_PROPERTIES);
        if (connInstanceTO.getAdminRealm() != null) {
            connInstance.setAdminRealm(this.realmDAO.findByFullPath(connInstanceTO.getAdminRealm()));
        }
        if (connInstance.getAdminRealm() == null) {
            sce.getElements().add("Invalid or null realm specified: " + connInstanceTO.getAdminRealm());
        }
        if (connInstanceTO.getLocation() != null) {
            connInstance.setLocation(connInstanceTO.getLocation());
        }
        connInstance.setConf((Collection)connInstanceTO.getConf());
        if (connInstanceTO.getPoolConf() != null) {
            connInstance.setPoolConf(ConnPoolConfUtils.getConnPoolConf((ConnPoolConfTO)connInstanceTO.getPoolConf(), (ConnPoolConf)this.entityFactory.newConnPoolConf()));
        }
        if (!sce.isEmpty()) {
            throw sce;
        }
        return connInstance;
    }

    public ConnInstance update(ConnInstanceTO connInstanceTO) {
        SyncopeClientException sce;
        ConnInstance connInstance = this.connInstanceDAO.authFind(connInstanceTO.getKey());
        if (connInstance == null) {
            throw new NotFoundException("Connector '" + connInstanceTO.getKey() + "'");
        }
        ConnInstanceTO current = this.getConnInstanceTO(connInstance);
        if (!current.equals((Object)connInstanceTO)) {
            ConnInstanceHistoryConf connInstanceHistoryConf = (ConnInstanceHistoryConf)this.entityFactory.newEntity(ConnInstanceHistoryConf.class);
            connInstanceHistoryConf.setCreator(AuthContextUtils.getUsername());
            connInstanceHistoryConf.setCreation(new Date());
            connInstanceHistoryConf.setEntity((Entity)connInstance);
            connInstanceHistoryConf.setConf((EntityTO)current);
            this.connInstanceHistoryConfDAO.save(connInstanceHistoryConf);
            List history = this.connInstanceHistoryConfDAO.findByEntity(connInstance);
            long maxHistorySize = (Long)this.confDAO.find("connector.conf.history.size", (Object)10L);
            if (maxHistorySize < (long)history.size()) {
                int i = 0;
                while ((long)i < (long)history.size() - maxHistorySize) {
                    this.connInstanceHistoryConfDAO.delete(((ConnInstanceHistoryConf)history.get(history.size() - 1)).getKey());
                    ++i;
                }
            }
        }
        connInstance.getCapabilities().clear();
        connInstance.getCapabilities().addAll(connInstanceTO.getCapabilities());
        if (connInstanceTO.getAdminRealm() != null) {
            Realm realm = this.realmDAO.findByFullPath(connInstanceTO.getAdminRealm());
            if (realm == null) {
                sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
                sce.getElements().add("Invalid or null realm specified: " + connInstanceTO.getAdminRealm());
                throw sce;
            }
            connInstance.setAdminRealm(realm);
        }
        if (connInstanceTO.getLocation() != null) {
            connInstance.setLocation(connInstanceTO.getLocation());
        }
        if (connInstanceTO.getBundleName() != null) {
            connInstance.setBundleName(connInstanceTO.getBundleName());
        }
        if (connInstanceTO.getVersion() != null) {
            connInstance.setVersion(connInstanceTO.getVersion());
        }
        if (connInstanceTO.getConnectorName() != null) {
            connInstance.setConnectorName(connInstanceTO.getConnectorName());
        }
        if (connInstanceTO.getConf() != null && !connInstanceTO.getConf().isEmpty()) {
            connInstance.setConf((Collection)connInstanceTO.getConf());
        }
        if (connInstanceTO.getDisplayName() != null) {
            connInstance.setDisplayName(connInstanceTO.getDisplayName());
        }
        if (connInstanceTO.getConnRequestTimeout() != null) {
            connInstance.setConnRequestTimeout(connInstanceTO.getConnRequestTimeout());
        }
        if (connInstanceTO.getPoolConf() == null) {
            connInstance.setPoolConf(null);
        } else {
            connInstance.setPoolConf(ConnPoolConfUtils.getConnPoolConf((ConnPoolConfTO)connInstanceTO.getPoolConf(), (ConnPoolConf)this.entityFactory.newConnPoolConf()));
        }
        try {
            connInstance = this.connInstanceDAO.save(connInstance);
        }
        catch (Exception e) {
            sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidConnInstance);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return connInstance;
    }

    public ConnConfPropSchema build(ConfigurationProperty property) {
        ConnConfPropSchema connConfPropSchema = new ConnConfPropSchema();
        connConfPropSchema.setName(property.getName());
        connConfPropSchema.setDisplayName(property.getDisplayName(property.getName()));
        connConfPropSchema.setHelpMessage(property.getHelpMessage(property.getName()));
        connConfPropSchema.setRequired(property.isRequired());
        connConfPropSchema.setType(property.getType().getName());
        connConfPropSchema.setOrder(((ConfigurationPropertyImpl)property).getOrder());
        connConfPropSchema.setConfidential(property.isConfidential());
        if (property.getValue() != null) {
            if (property.getValue().getClass().isArray()) {
                connConfPropSchema.getDefaultValues().addAll(Arrays.asList((Object[])property.getValue()));
            } else if (property.getValue() instanceof Collection) {
                connConfPropSchema.getDefaultValues().addAll((Collection)property.getValue());
            } else {
                connConfPropSchema.getDefaultValues().add(property.getValue());
            }
        }
        return connConfPropSchema;
    }

    public ConnInstanceTO getConnInstanceTO(ConnInstance connInstance) {
        ConnInstanceTO connInstanceTO = new ConnInstanceTO();
        Pair info = this.connIdBundleManager.getConnectorInfo(connInstance);
        BeanUtils.copyProperties((Object)connInstance, (Object)connInstanceTO, (String[])IGNORE_PROPERTIES);
        connInstanceTO.setAdminRealm(connInstance.getAdminRealm().getFullPath());
        connInstanceTO.setLocation(((URI)info.getLeft()).toASCIIString());
        connInstanceTO.getConf().addAll(connInstance.getConf());
        ConfigurationProperties properties = this.connIdBundleManager.getConfigurationProperties((ConnectorInfo)info.getRight());
        for (String propName : properties.getPropertyNames()) {
            ConnConfPropSchema schema = this.build(properties.getProperty(propName));
            ConnConfProperty property = connInstanceTO.getConf(propName);
            if (property == null) {
                property = new ConnConfProperty();
                connInstanceTO.getConf().add(property);
            }
            property.setSchema(schema);
        }
        Collections.sort(connInstanceTO.getConf());
        if (connInstance.getPoolConf() != null && (connInstance.getPoolConf().getMaxIdle() != null || connInstance.getPoolConf().getMaxObjects() != null || connInstance.getPoolConf().getMaxWait() != null || connInstance.getPoolConf().getMinEvictableIdleTimeMillis() != null || connInstance.getPoolConf().getMinIdle() != null)) {
            ConnPoolConfTO poolConf = new ConnPoolConfTO();
            BeanUtils.copyProperties((Object)connInstance.getPoolConf(), (Object)poolConf);
            connInstanceTO.setPoolConf(poolConf);
        }
        return connInstanceTO;
    }

    public ConnInstanceHistoryConfTO getConnInstanceHistoryConfTO(ConnInstanceHistoryConf history) {
        ConnInstanceHistoryConfTO historyTO = new ConnInstanceHistoryConfTO();
        historyTO.setKey(history.getKey());
        historyTO.setCreator(history.getCreator());
        historyTO.setCreation(history.getCreation());
        historyTO.setConnInstanceTO((ConnInstanceTO)history.getConf());
        return historyTO;
    }
}

