/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.AnyObjectPatch;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.AttrPatch;
import org.apache.syncope.common.lib.patch.MembershipPatch;
import org.apache.syncope.common.lib.patch.RelationshipPatch;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.GroupablePlainAttr;
import org.apache.syncope.core.persistence.api.entity.GroupableRelatable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.anyobject.AMembership;
import org.apache.syncope.core.persistence.api.entity.anyobject.APlainAttr;
import org.apache.syncope.core.persistence.api.entity.anyobject.ARelationship;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.AnyObjectDataBinder;
import org.apache.syncope.core.provisioning.java.data.AbstractAnyDataBinder;
import org.apache.syncope.core.spring.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Throwable.class})
public class AnyObjectDataBinderImpl
extends AbstractAnyDataBinder
implements AnyObjectDataBinder {
    private static final String[] IGNORE_PROPERTIES = new String[]{"type", "realm", "auxClasses", "relationships", "memberships", "dynMemberships", "plainAttrs", "derAttrs", "virAttrs", "resources"};
    @Autowired
    private AnyTypeDAO anyTypeDAO;

    @Transactional(readOnly=true)
    public AnyObjectTO getAnyObjectTO(String key) {
        return this.getAnyObjectTO((AnyObject)this.anyObjectDAO.authFind(key), true);
    }

    public AnyObjectTO getAnyObjectTO(final AnyObject anyObject, boolean details) {
        AnyObjectTO anyObjectTO = new AnyObjectTO();
        anyObjectTO.setType(anyObject.getType().getKey());
        BeanUtils.copyProperties((Object)anyObject, (Object)anyObjectTO, (String[])IGNORE_PROPERTIES);
        Map virAttrValues = details ? this.virAttrHandler.getValues((Any)anyObject) : Collections.emptyMap();
        this.fillTO((AnyTO)anyObjectTO, anyObject.getRealm().getFullPath(), anyObject.getAuxClasses(), anyObject.getPlainAttrs(), this.derAttrHandler.getValues((Any)anyObject), virAttrValues, this.anyObjectDAO.findAllResources(anyObject), details);
        if (details) {
            anyObjectTO.getDynRealms().addAll(this.userDAO.findDynRealms(anyObject.getKey()));
            CollectionUtils.collect((Iterable)this.anyObjectDAO.findAllRelationships(anyObject), (Transformer)new Transformer<Relationship<Any<?>, Any<?>>, RelationshipTO>(){

                public RelationshipTO transform(Relationship<Any<?>, Any<?>> relationship) {
                    return AnyObjectDataBinderImpl.this.getRelationshipTO(relationship.getType().getKey(), relationship.getLeftEnd().getKey().equals(anyObject.getKey()) ? relationship.getRightEnd() : relationship.getLeftEnd());
                }
            }, (Collection)anyObjectTO.getRelationships());
            CollectionUtils.collect((Iterable)anyObject.getMemberships(), (Transformer)new Transformer<AMembership, MembershipTO>(){

                public MembershipTO transform(AMembership membership) {
                    return AnyObjectDataBinderImpl.this.getMembershipTO(anyObject.getPlainAttrs((Membership)membership), AnyObjectDataBinderImpl.this.derAttrHandler.getValues((GroupableRelatable)anyObject, (Membership)membership), AnyObjectDataBinderImpl.this.virAttrHandler.getValues((Any)anyObject, (Membership)membership), (Membership<? extends Any<?>>)membership);
                }
            }, (Collection)anyObjectTO.getMemberships());
            CollectionUtils.collect((Iterable)this.anyObjectDAO.findDynGroups(anyObject.getKey()), (Transformer)new Transformer<Group, MembershipTO>(){

                public MembershipTO transform(Group group) {
                    MembershipTO membershipTO = new MembershipTO.Builder().group(group.getKey(), group.getName()).build();
                    return membershipTO;
                }
            }, (Collection)anyObjectTO.getDynMemberships());
        }
        return anyObjectTO;
    }

    public void create(AnyObject anyObject, AnyObjectTO anyObjectTO) {
        AnyType type = this.anyTypeDAO.find(anyObjectTO.getType());
        if (type == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
            sce.getElements().add(anyObjectTO.getType());
            throw sce;
        }
        anyObject.setType(type);
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        SyncopeClientException invalidGroups = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidGroup);
        if (anyObjectTO.getName() == null) {
            LOG.error("No name specified for this anyObject");
            invalidGroups.getElements().add("No name specified for this anyObject");
        } else {
            anyObject.setName(anyObjectTO.getName());
        }
        Realm realm = this.realmDAO.findByFullPath(anyObjectTO.getRealm());
        if (realm == null) {
            SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            noRealm.getElements().add("Invalid or null realm specified: " + anyObjectTO.getRealm());
            scce.addException(noRealm);
        }
        anyObject.setRealm(realm);
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(AnyTypeKind.ANY_OBJECT);
        if (anyObject.getRealm() != null) {
            for (RelationshipTO relationshipTO : anyObjectTO.getRelationships()) {
                if (StringUtils.isBlank((CharSequence)relationshipTO.getOtherEndType()) || AnyTypeKind.USER.name().equals(relationshipTO.getOtherEndType()) || AnyTypeKind.GROUP.name().equals(relationshipTO.getOtherEndType())) {
                    SyncopeClientException invalidAnyType = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
                    invalidAnyType.getElements().add(AnyType.class.getSimpleName() + " not allowed for relationship: " + relationshipTO.getOtherEndType());
                    scce.addException(invalidAnyType);
                    continue;
                }
                AnyObject otherEnd = (AnyObject)this.anyObjectDAO.find(relationshipTO.getOtherEndKey());
                if (otherEnd == null) {
                    LOG.debug("Ignoring invalid anyObject " + relationshipTO.getOtherEndKey());
                    continue;
                }
                if (anyObject.getRealm().getFullPath().startsWith(otherEnd.getRealm().getFullPath())) {
                    RelationshipType relationshipType = this.relationshipTypeDAO.find(relationshipTO.getType());
                    if (relationshipType == null) {
                        LOG.debug("Ignoring invalid relationship type {}", (Object)relationshipTO.getType());
                        continue;
                    }
                    ARelationship relationship = (ARelationship)this.entityFactory.newEntity(ARelationship.class);
                    relationship.setType(relationshipType);
                    relationship.setRightEnd((Any)otherEnd);
                    relationship.setLeftEnd((Any)anyObject);
                    anyObject.add((Relationship)relationship);
                    continue;
                }
                LOG.error("{} cannot be assigned to {}", (Object)otherEnd, (Object)anyObject);
                SyncopeClientException unassignabled = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                unassignabled.getElements().add("Cannot be assigned: " + otherEnd);
                scce.addException(unassignabled);
            }
            for (MembershipTO membershipTO : anyObjectTO.getMemberships()) {
                Group group;
                Group group2 = group = membershipTO.getGroupKey() == null ? this.groupDAO.findByName(membershipTO.getGroupName()) : (Group)this.groupDAO.find(membershipTO.getGroupKey());
                if (group == null) {
                    LOG.debug("Ignoring invalid group " + membershipTO.getGroupKey() + " / " + membershipTO.getGroupName());
                    continue;
                }
                if (anyObject.getRealm().getFullPath().startsWith(group.getRealm().getFullPath())) {
                    AMembership membership = (AMembership)this.entityFactory.newEntity(AMembership.class);
                    membership.setRightEnd((Any)group);
                    membership.setLeftEnd((Any)anyObject);
                    anyObject.add((Membership)membership);
                    this.fill((Any)anyObject, (Membership)membership, membershipTO, anyUtils, scce);
                    continue;
                }
                LOG.error("{} cannot be assigned to {}", (Object)group, (Object)anyObject);
                SyncopeClientException unassignable = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
                unassignable.getElements().add("Cannot be assigned: " + group);
                scce.addException(unassignable);
            }
        }
        this.fill((Any)anyObject, (AnyTO)anyObjectTO, anyUtils, scce);
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    public PropagationByResource update(AnyObject toBeUpdated, AnyObjectPatch anyObjectPatch) {
        AnyObject anyObject = (AnyObject)this.anyObjectDAO.save((Any)toBeUpdated);
        PropagationByResource propByRes = new PropagationByResource();
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(AnyTypeKind.ANY_OBJECT);
        Collection currentResources = this.anyObjectDAO.findAllResourceKeys(anyObject.getKey());
        Map<String, String> oldConnObjectKeys = this.getConnObjectKeys((Any<?>)anyObject, anyUtils);
        this.setRealm((Any<?>)anyObject, (AnyPatch)anyObjectPatch);
        if (anyObjectPatch.getName() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)anyObjectPatch.getName().getValue()))) {
            propByRes.addAll(ResourceOperation.UPDATE, this.anyObjectDAO.findAllResourceKeys(anyObject.getKey()));
            anyObject.setName((String)anyObjectPatch.getName().getValue());
        }
        propByRes.merge(this.fill((Any)anyObject, (AnyPatch)anyObjectPatch, anyUtils, scce));
        for (RelationshipPatch patch : anyObjectPatch.getRelationships()) {
            if (patch.getRelationshipTO() == null) continue;
            RelationshipType relationshipType = this.relationshipTypeDAO.find(patch.getRelationshipTO().getType());
            if (relationshipType == null) {
                LOG.debug("Ignoring invalid relationship type {}", (Object)patch.getRelationshipTO().getType());
                continue;
            }
            ARelationship relationship = (ARelationship)anyObject.getRelationship(relationshipType, patch.getRelationshipTO().getOtherEndKey());
            if (relationship != null) {
                anyObject.getRelationships().remove(relationship);
                relationship.setLeftEnd(null);
                relationship.setRightEnd(null);
            }
            if (patch.getOperation() != PatchOperation.ADD_REPLACE) continue;
            if (StringUtils.isBlank((CharSequence)patch.getRelationshipTO().getOtherEndType()) || AnyTypeKind.USER.name().equals(patch.getRelationshipTO().getOtherEndType()) || AnyTypeKind.GROUP.name().equals(patch.getRelationshipTO().getOtherEndType())) {
                SyncopeClientException invalidAnyType = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
                invalidAnyType.getElements().add(AnyType.class.getSimpleName() + " not allowed for relationship: " + patch.getRelationshipTO().getOtherEndType());
                scce.addException(invalidAnyType);
                continue;
            }
            AnyObject otherEnd = (AnyObject)this.anyObjectDAO.find(patch.getRelationshipTO().getOtherEndKey());
            if (otherEnd == null) {
                LOG.debug("Ignoring invalid any object {}", (Object)patch.getRelationshipTO().getOtherEndKey());
                continue;
            }
            if (anyObject.getRealm().getFullPath().startsWith(otherEnd.getRealm().getFullPath())) {
                relationship = (ARelationship)this.entityFactory.newEntity(ARelationship.class);
                relationship.setType(relationshipType);
                relationship.setRightEnd((Any)otherEnd);
                relationship.setLeftEnd((Any)anyObject);
                anyObject.add((Relationship)relationship);
                continue;
            }
            LOG.error("{} cannot be assigned to {}", (Object)otherEnd, (Object)anyObject);
            SyncopeClientException unassignable = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
            unassignable.getElements().add("Cannot be assigned: " + otherEnd);
            scce.addException(unassignable);
        }
        Collection resources = this.anyObjectDAO.findAllResources(anyObject);
        HashMap reasons = new HashMap();
        for (ExternalResource resource : anyObject.getResources()) {
            reasons.put(resource.getKey(), new HashSet<String>(Collections.singleton(anyObject.getKey())));
        }
        for (String group : this.anyObjectDAO.findAllGroupKeys(anyObject)) {
            for (Object resource : this.groupDAO.findAllResourceKeys(group)) {
                if (!reasons.containsKey(resource)) {
                    reasons.put(resource, new HashSet());
                }
                ((Set)reasons.get(resource)).add(group);
            }
        }
        HashSet toBeDeprovisioned = new HashSet();
        HashSet<Object> toBeProvisioned = new HashSet<Object>();
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        for (MembershipPatch membPatch : anyObjectPatch.getMemberships()) {
            if (membPatch.getGroup() == null) continue;
            AMembership aMembership = (AMembership)anyObject.getMembership(membPatch.getGroup());
            if (aMembership != null) {
                anyObject.getMemberships().remove(aMembership);
                aMembership.setLeftEnd(null);
                for (APlainAttr attr : anyObject.getPlainAttrs((Membership)aMembership)) {
                    anyObject.remove((GroupablePlainAttr)attr);
                    attr.setOwner(null);
                }
                if (membPatch.getOperation() == PatchOperation.DELETE) {
                    for (Object resource : this.groupDAO.findAllResourceKeys(((Group)aMembership.getRightEnd()).getKey())) {
                        if (!reasons.containsKey(resource)) continue;
                        ((Set)reasons.get(resource)).remove(((Group)aMembership.getRightEnd()).getKey());
                        toBeProvisioned.add(resource);
                    }
                }
            }
            if (membPatch.getOperation() != PatchOperation.ADD_REPLACE) continue;
            Group group = (Group)this.groupDAO.find(membPatch.getGroup());
            if (group == null) {
                LOG.debug("Ignoring invalid group {}", (Object)membPatch.getGroup());
                continue;
            }
            if (anyObject.getRealm().getFullPath().startsWith(group.getRealm().getFullPath())) {
                Object resource;
                AMembership aMembership2 = (AMembership)this.entityFactory.newEntity(AMembership.class);
                aMembership2.setRightEnd((Any)group);
                aMembership2.setLeftEnd((Any)anyObject);
                anyObject.add((Membership)aMembership2);
                resource = membPatch.getPlainAttrs().iterator();
                while (resource.hasNext()) {
                    AttrTO attrTO = (AttrTO)resource.next();
                    PlainSchema schema = this.getPlainSchema(attrTO.getSchema());
                    if (schema == null) {
                        LOG.debug("Invalid " + PlainSchema.class.getSimpleName() + "{}, ignoring...", (Object)attrTO.getSchema());
                        continue;
                    }
                    APlainAttr attr = (APlainAttr)anyObject.getPlainAttr(schema.getKey(), (Membership)aMembership2);
                    if (attr != null) continue;
                    LOG.debug("No plain attribute found for {} and membership of {}", (Object)schema, (Object)aMembership2.getRightEnd());
                    attr = (APlainAttr)anyUtils.newPlainAttr();
                    attr.setOwner((Any)anyObject);
                    attr.setMembership((Membership)aMembership2);
                    attr.setSchema(schema);
                    anyObject.add((GroupablePlainAttr)attr);
                    AttrPatch patch = (AttrPatch)new AttrPatch.Builder().attrTO(attrTO).build();
                    this.processAttrPatch((Any)anyObject, patch, schema, (PlainAttr<?>)attr, anyUtils, resources, propByRes, invalidValues);
                }
                if (!invalidValues.isEmpty()) {
                    scce.addException(invalidValues);
                }
                toBeProvisioned.addAll(this.groupDAO.findAllResourceKeys(group.getKey()));
                continue;
            }
            LOG.error("{} cannot be assigned to {}", (Object)group, (Object)anyObject);
            SyncopeClientException unassignabled = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
            unassignabled.getElements().add("Cannot be assigned: " + group);
            scce.addException(unassignabled);
        }
        for (Map.Entry entry : reasons.entrySet()) {
            if (!((Set)entry.getValue()).isEmpty()) continue;
            toBeDeprovisioned.add(entry.getKey());
        }
        propByRes.addAll(ResourceOperation.DELETE, toBeDeprovisioned);
        propByRes.addAll(ResourceOperation.UPDATE, toBeProvisioned);
        if (!toBeDeprovisioned.isEmpty() || !toBeProvisioned.isEmpty()) {
            currentResources.removeAll(toBeDeprovisioned);
            propByRes.addAll(ResourceOperation.UPDATE, currentResources);
        }
        Map<String, String> newcCnnObjectKeys = this.getConnObjectKeys((Any<?>)anyObject, anyUtils);
        for (Map.Entry entry : oldConnObjectKeys.entrySet()) {
            if (!newcCnnObjectKeys.containsKey(entry.getKey()) || ((String)entry.getValue()).equals(newcCnnObjectKeys.get(entry.getKey()))) continue;
            propByRes.addOldConnObjectKey((String)entry.getKey(), (String)entry.getValue());
            propByRes.add(ResourceOperation.UPDATE, (String)entry.getKey());
        }
        Pair dynGroupMembs = this.anyObjectDAO.saveAndGetDynGroupMembs(anyObject);
        for (String delete : SetUtils.difference((Set)((Set)dynGroupMembs.getLeft()), (Set)((Set)dynGroupMembs.getRight()))) {
            for (ExternalResource resource : ((Group)this.groupDAO.find(delete)).getResources()) {
                if (propByRes.contains(resource.getKey())) continue;
                propByRes.add(ResourceOperation.DELETE, resource.getKey());
            }
        }
        for (String update : SetUtils.intersection((Set)((Set)dynGroupMembs.getLeft()), (Set)((Set)dynGroupMembs.getRight()))) {
            for (ExternalResource resource : ((Group)this.groupDAO.find(update)).getResources()) {
                if (propByRes.contains(resource.getKey())) continue;
                propByRes.add(ResourceOperation.UPDATE, resource.getKey());
            }
        }
        for (String create : SetUtils.difference((Set)((Set)dynGroupMembs.getRight()), (Set)((Set)dynGroupMembs.getLeft()))) {
            for (ExternalResource resource : ((Group)this.groupDAO.find(create)).getResources()) {
                if (propByRes.contains(resource.getKey())) continue;
                propByRes.add(ResourceOperation.CREATE, resource.getKey());
            }
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
        return propByRes;
    }
}

