/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.GroupPatch;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.provisioning.api.GroupProvisioningManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.workflow.api.GroupWorkflowAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DefaultGroupProvisioningManager
implements GroupProvisioningManager {
    @Autowired
    protected GroupWorkflowAdapter gwfAdapter;
    @Autowired
    protected PropagationManager propagationManager;
    @Autowired
    protected PropagationTaskExecutor taskExecutor;
    @Autowired
    protected GroupDataBinder groupDataBinder;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected VirAttrHandler virtAttrHandler;

    public Pair<String, List<PropagationStatus>> create(GroupTO groupTO, boolean nullPriorityAsync) {
        WorkflowResult created = this.gwfAdapter.create(groupTO);
        List tasks = this.propagationManager.getCreateTasks(AnyTypeKind.GROUP, (String)created.getResult(), null, created.getPropByRes(), (Collection)groupTO.getVirAttrs(), Collections.emptySet());
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)tasks, nullPriorityAsync);
        return Pair.of((Object)created.getResult(), (Object)propagationReporter.getStatuses());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Pair<String, List<PropagationStatus>> create(GroupTO groupTO, Map<String, String> groupOwnerMap, Set<String> excludedResources, boolean nullPriorityAsync) {
        WorkflowResult created = this.gwfAdapter.create(groupTO);
        AttrTO groupOwner = groupTO.getPlainAttr("");
        if (groupOwner != null) {
            groupOwnerMap.put((String)created.getResult(), (String)groupOwner.getValues().iterator().next());
        }
        List tasks = this.propagationManager.getCreateTasks(AnyTypeKind.GROUP, (String)created.getResult(), null, created.getPropByRes(), (Collection)groupTO.getVirAttrs(), excludedResources);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)tasks, nullPriorityAsync);
        return Pair.of((Object)created.getResult(), (Object)propagationReporter.getStatuses());
    }

    public Pair<GroupPatch, List<PropagationStatus>> update(GroupPatch groupPatch, boolean nullPriorityAsync) {
        return this.update(groupPatch, Collections.emptySet(), nullPriorityAsync);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Pair<GroupPatch, List<PropagationStatus>> update(GroupPatch groupPatch, Set<String> excludedResources, boolean nullPriorityAsync) {
        WorkflowResult updated = this.gwfAdapter.update(groupPatch);
        List tasks = this.propagationManager.getUpdateTasks(AnyTypeKind.GROUP, ((GroupPatch)updated.getResult()).getKey(), false, null, updated.getPropByRes(), (Collection)groupPatch.getVirAttrs(), excludedResources);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)tasks, nullPriorityAsync);
        return Pair.of((Object)updated.getResult(), (Object)propagationReporter.getStatuses());
    }

    public List<PropagationStatus> delete(String key, boolean nullPriorityAsync) {
        return this.delete(key, Collections.emptySet(), nullPriorityAsync);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<PropagationStatus> delete(String key, Set<String> excludedResources, boolean nullPriorityAsync) {
        ArrayList tasks = new ArrayList();
        for (Map.Entry entry : this.groupDataBinder.findUsersWithTransitiveResources(key).entrySet()) {
            tasks.addAll(this.propagationManager.getDeleteTasks(AnyTypeKind.USER, (String)entry.getKey(), (PropagationByResource)entry.getValue(), excludedResources));
        }
        for (Map.Entry entry : this.groupDataBinder.findAnyObjectsWithTransitiveResources(key).entrySet()) {
            tasks.addAll(this.propagationManager.getDeleteTasks(AnyTypeKind.ANY_OBJECT, (String)entry.getKey(), (PropagationByResource)entry.getValue(), excludedResources));
        }
        tasks.addAll(this.propagationManager.getDeleteTasks(AnyTypeKind.GROUP, key, null, null));
        PropagationReporter propagationReporter = this.taskExecutor.execute(tasks, nullPriorityAsync);
        this.gwfAdapter.delete(key);
        return propagationReporter.getStatuses();
    }

    public String unlink(GroupPatch groupPatch) {
        return ((GroupPatch)this.gwfAdapter.update(groupPatch).getResult()).getKey();
    }

    public List<PropagationStatus> provision(String key, Collection<String> resources, boolean nullPriorityAsync) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.UPDATE, resources);
        List tasks = this.propagationManager.getUpdateTasks(AnyTypeKind.GROUP, key, false, null, propByRes, null, null);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)tasks, nullPriorityAsync);
        return propagationReporter.getStatuses();
    }

    public List<PropagationStatus> deprovision(String key, Collection<String> resources, boolean nullPriorityAsync) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.DELETE, resources);
        List tasks = this.propagationManager.getDeleteTasks(AnyTypeKind.GROUP, key, propByRes, CollectionUtils.removeAll((Collection)this.groupDAO.findAllResourceKeys(key), resources));
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)tasks, nullPriorityAsync);
        return propagationReporter.getStatuses();
    }

    public String link(GroupPatch groupPatch) {
        return ((GroupPatch)this.gwfAdapter.update(groupPatch).getResult()).getKey();
    }
}

