/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.text.ParseException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.ItemTO;
import org.apache.syncope.common.lib.to.SAML2IdPTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.SAML2IdPDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.SAML2EntityFactory;
import org.apache.syncope.core.persistence.api.entity.SAML2IdP;
import org.apache.syncope.core.persistence.api.entity.SAML2IdPItem;
import org.apache.syncope.core.persistence.api.entity.SAML2UserTemplate;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.data.SAML2IdPDataBinder;
import org.apache.syncope.core.provisioning.api.utils.EntityUtils;
import org.apache.syncope.core.provisioning.java.IntAttrNameParser;
import org.apache.syncope.core.provisioning.java.jexl.JexlUtils;
import org.apache.syncope.core.spring.BeanUtils;
import org.identityconnectors.common.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SAML2IdPDataBinderImpl
implements SAML2IdPDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(SAML2IdPDataBinder.class);
    private static final String[] ITEM_IGNORE_PROPERTIES = new String[]{"key", "purpose"};
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private SAML2IdPDAO saml2IdPDAO;
    @Autowired
    private SAML2EntityFactory entityFactory;
    @Autowired
    private IntAttrNameParser intAttrNameParser;

    public SAML2IdP create(SAML2IdPTO idpTO) {
        return this.update((SAML2IdP)this.entityFactory.newEntity(SAML2IdP.class), idpTO);
    }

    private void populateItems(SAML2IdPTO idpTO, SAML2IdP idp, AnyTypeClassTO allowedSchemas) {
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        SyncopeClientException invalidMapping = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMapping);
        SyncopeClientException requiredValuesMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        for (ItemTO itemTO : idpTO.getItems()) {
            if (itemTO == null) {
                LOG.error("Null {}", (Object)ItemTO.class.getSimpleName());
                invalidMapping.getElements().add("Null " + ItemTO.class.getSimpleName());
                continue;
            }
            if (itemTO.getIntAttrName() == null) {
                requiredValuesMissing.getElements().add("intAttrName");
                scce.addException(requiredValuesMissing);
                continue;
            }
            IntAttrName intAttrName = null;
            try {
                intAttrName = this.intAttrNameParser.parse(itemTO.getIntAttrName(), AnyTypeKind.USER);
            }
            catch (ParseException e) {
                LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)itemTO.getIntAttrName(), (Object)e);
            }
            if (intAttrName == null || intAttrName.getSchemaType() == null && intAttrName.getField() == null) {
                LOG.error("'{}' not existing", (Object)itemTO.getIntAttrName());
                invalidMapping.getElements().add("'" + itemTO.getIntAttrName() + "' not existing");
                continue;
            }
            boolean allowed = true;
            if (intAttrName.getSchemaType() != null && intAttrName.getEnclosingGroup() == null && intAttrName.getRelatedAnyObject() == null) {
                switch (intAttrName.getSchemaType()) {
                    case PLAIN: {
                        allowed = allowedSchemas.getPlainSchemas().contains(intAttrName.getSchemaName());
                        break;
                    }
                    case DERIVED: {
                        allowed = allowedSchemas.getDerSchemas().contains(intAttrName.getSchemaName());
                        break;
                    }
                    case VIRTUAL: {
                        allowed = allowedSchemas.getVirSchemas().contains(intAttrName.getSchemaName());
                        break;
                    }
                }
            }
            if (allowed) {
                if (!JexlUtils.isExpressionValid((String)(itemTO.getMandatoryCondition() == null ? "false" : itemTO.getMandatoryCondition()))) {
                    SyncopeClientException invalidMandatoryCondition = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
                    invalidMandatoryCondition.getElements().add(itemTO.getMandatoryCondition());
                    scce.addException(invalidMandatoryCondition);
                }
                SAML2IdPItem item = (SAML2IdPItem)this.entityFactory.newEntity(SAML2IdPItem.class);
                BeanUtils.copyProperties((Object)itemTO, (Object)item, (String[])ITEM_IGNORE_PROPERTIES);
                item.setIdP(idp);
                item.setPurpose(MappingPurpose.NONE);
                if (item.isConnObjectKey()) {
                    if (intAttrName.getSchemaType() == SchemaType.VIRTUAL) {
                        invalidMapping.getElements().add("Virtual attributes cannot be set as ConnObjectKey");
                    }
                    if ("password".equals(intAttrName.getField())) {
                        invalidMapping.getElements().add("Password attributes cannot be set as ConnObjectKey");
                    }
                    idp.setConnObjectKeyItem(item);
                    continue;
                }
                idp.add(item);
                continue;
            }
            LOG.error("'{}' not allowed", (Object)itemTO.getIntAttrName());
            invalidMapping.getElements().add("'" + itemTO.getIntAttrName() + "' not allowed");
        }
        if (!invalidMapping.getElements().isEmpty()) {
            scce.addException(invalidMapping);
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    public SAML2IdP update(SAML2IdP idp, SAML2IdPTO idpTO) {
        idp.setEntityID(idpTO.getEntityID());
        idp.setName(idpTO.getName());
        idp.setMetadata(Base64.decode((String)idpTO.getMetadata()));
        idp.setCreateUnmatching(idpTO.isCreateUnmatching());
        idp.setSelfRegUnmatching(idpTO.isSelfRegUnmatching());
        idp.setUpdateMatching(idpTO.isUpdateMatching());
        idp.setUseDeflateEncoding(idpTO.isUseDeflateEncoding());
        idp.setSupportUnsolicited(idpTO.isSupportUnsolicited());
        idp.setBindingType(idpTO.getBindingType());
        if (idpTO.getUserTemplate() == null) {
            idp.setUserTemplate(null);
        } else {
            SAML2UserTemplate userTemplate = idp.getUserTemplate();
            if (userTemplate == null) {
                userTemplate = (SAML2UserTemplate)this.entityFactory.newEntity(SAML2UserTemplate.class);
                userTemplate.setAnyType(this.anyTypeDAO.findUser());
                userTemplate.setIdP(idp);
                idp.setUserTemplate(userTemplate);
            }
            userTemplate.set((AnyTO)idpTO.getUserTemplate());
        }
        idp.getItems().clear();
        AnyTypeClassTO allowedSchemas = new AnyTypeClassTO();
        for (AnyTypeClass anyTypeClass : this.anyTypeDAO.findUser().getClasses()) {
            allowedSchemas.getPlainSchemas().addAll(CollectionUtils.collect((Iterable)anyTypeClass.getPlainSchemas(), (Transformer)EntityUtils.keyTransformer()));
            allowedSchemas.getDerSchemas().addAll(CollectionUtils.collect((Iterable)anyTypeClass.getDerSchemas(), (Transformer)EntityUtils.keyTransformer()));
            allowedSchemas.getVirSchemas().addAll(CollectionUtils.collect((Iterable)anyTypeClass.getVirSchemas(), (Transformer)EntityUtils.keyTransformer()));
        }
        this.populateItems(idpTO, idp, allowedSchemas);
        idp.getActionsClassNames().clear();
        idp.getActionsClassNames().addAll(idpTO.getActionsClassNames());
        return this.saml2IdPDAO.save(idp);
    }

    private void populateItems(SAML2IdP idp, SAML2IdPTO idpTO) {
        for (SAML2IdPItem item : idp.getItems()) {
            ItemTO itemTO = new ItemTO();
            itemTO.setKey(item.getKey());
            BeanUtils.copyProperties((Object)item, (Object)itemTO, (String[])ITEM_IGNORE_PROPERTIES);
            itemTO.setPurpose(MappingPurpose.NONE);
            if (itemTO.isConnObjectKey()) {
                idpTO.setConnObjectKeyItem(itemTO);
                continue;
            }
            idpTO.add(itemTO);
        }
    }

    public SAML2IdPTO getIdPTO(SAML2IdP idp) {
        SAML2IdPTO idpTO = new SAML2IdPTO();
        idpTO.setKey(idp.getKey());
        idpTO.setEntityID(idp.getEntityID());
        idpTO.setName(idp.getName());
        idpTO.setUseDeflateEncoding(idp.isUseDeflateEncoding());
        idpTO.setSupportUnsolicited(idp.isSupportUnsolicited());
        idpTO.setBindingType(idp.getBindingType());
        idpTO.setCreateUnmatching(idp.isCreateUnmatching());
        idpTO.setSelfRegUnmatching(idp.isSelfRegUnmatching());
        idpTO.setUpdateMatching(idp.isUpdateMatching());
        idpTO.setMetadata(Base64.encode((byte[])idp.getMetadata()));
        if (idp.getUserTemplate() != null) {
            idpTO.setUserTemplate((UserTO)idp.getUserTemplate().get());
        }
        this.populateItems(idp, idpTO);
        idpTO.getActionsClassNames().addAll(idp.getActionsClassNames());
        return idpTO;
    }
}

