/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.syncope.common.lib.to.WorkflowDefinitionTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.workflow.api.AnyObjectWorkflowDefinitionAdapter;
import org.apache.syncope.core.workflow.api.GroupWorkflowDefinitionAdapter;
import org.apache.syncope.core.workflow.api.UserWorkflowDefinitionAdapter;
import org.apache.syncope.core.workflow.api.WorkflowDefinitionAdapter;
import org.apache.syncope.core.workflow.api.WorkflowDefinitionFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WorkflowLogic
extends AbstractTransactionalLogic<WorkflowDefinitionTO> {
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private AnyObjectWorkflowDefinitionAdapter awfAdapter;
    @Autowired
    private UserWorkflowDefinitionAdapter uwfAdapter;
    @Autowired
    private GroupWorkflowDefinitionAdapter gwfAdapter;

    private WorkflowDefinitionAdapter getAdapter(String anyTypeKey) {
        AnyType anyType = this.anyTypeDAO.find(anyTypeKey);
        if (anyType == null) {
            LOG.error("Could not find anyType '" + anyTypeKey + "'");
            throw new NotFoundException(anyTypeKey);
        }
        switch (anyType.getKind()) {
            case ANY_OBJECT: {
                return this.awfAdapter;
            }
            case GROUP: {
                return this.gwfAdapter;
            }
        }
        return this.uwfAdapter;
    }

    @PreAuthorize(value="hasRole('WORKFLOW_DEF_LIST')")
    @Transactional(readOnly=true)
    public List<WorkflowDefinitionTO> list(String anyType) {
        return this.getAdapter(anyType).getDefinitions();
    }

    @PreAuthorize(value="hasRole('WORKFLOW_DEF_GET')")
    @Transactional(readOnly=true)
    public void exportDefinition(String anyType, String key, WorkflowDefinitionFormat format, OutputStream os) {
        this.getAdapter(anyType).exportDefinition(key, format, os);
    }

    @PreAuthorize(value="hasRole('WORKFLOW_DEF_GET')")
    @Transactional(readOnly=true)
    public void exportDiagram(String anyType, String key, OutputStream os) {
        this.getAdapter(anyType).exportDiagram(key, os);
    }

    @PreAuthorize(value="hasRole('WORKFLOW_DEF_GET')")
    public void importDefinition(String anyType, String key, WorkflowDefinitionFormat format, String definition) {
        this.getAdapter(anyType).importDefinition(key, format, definition);
    }

    @PreAuthorize(value="hasRole('WORKFLOW_DEF_DELETE')")
    public void delete(String anyType, String key) {
        this.getAdapter(anyType).deleteDefinition(key);
    }

    @Override
    protected WorkflowDefinitionTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

