/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.AbstractBaseBean;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.ReconStatus;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorFactory;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeSinglePullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeSinglePushExecutor;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.Uid;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component
public class ReconciliationLogic
extends AbstractTransactionalLogic<AbstractBaseBean> {
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    private MappingManager mappingManager;
    @Autowired
    private ConnectorFactory connFactory;
    @Autowired
    private SyncopeSinglePullExecutor singlePullExecutor;
    @Autowired
    private SyncopeSinglePushExecutor singlePushExecutor;

    private Pair<Any<?>, Provision> init(AnyTypeKind anyTypeKind, String anyKey, String resourceKey) {
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(anyTypeKind);
        Any any = anyUtils.dao().authFind(anyKey);
        if (any == null) {
            throw new NotFoundException(anyTypeKind + " '" + anyKey + "'");
        }
        ExternalResource resource = this.resourceDAO.find(resourceKey);
        if (resource == null) {
            throw new NotFoundException("Resource '" + resourceKey + "'");
        }
        Provision provision = resource.getProvision(any.getType());
        if (provision == null) {
            throw new NotFoundException("Provision for " + any.getType() + " on Resource '" + resourceKey + "'");
        }
        if (provision.getMapping() == null) {
            throw new NotFoundException("Mapping for " + any.getType() + " on Resource '" + resourceKey + "'");
        }
        return Pair.of((Object)any, (Object)provision);
    }

    private ConnObjectTO getOnSyncope(Any<?> any, Provision provision, String resourceKey) {
        Pair attrs = this.mappingManager.prepareAttrs(any, null, false, Boolean.valueOf(true), provision);
        MappingItem connObjectKey = provision.getMapping().getConnObjectKeyItem();
        if (connObjectKey == null) {
            throw new NotFoundException("No RemoteKey set for " + resourceKey);
        }
        ConnObjectTO connObjectTO = ConnObjectUtils.getConnObjectTO((Set)((Set)attrs.getRight()));
        if (attrs.getLeft() != null) {
            connObjectTO.getAttrs().add(new AttrTO.Builder().schema(connObjectKey.getExtAttrName()).value((String)attrs.getLeft()).build());
            connObjectTO.getAttrs().add(new AttrTO.Builder().schema(Uid.NAME).value((String)attrs.getLeft()).build());
        }
        return connObjectTO;
    }

    private ConnObjectTO getOnResource(Any<?> any, Provision provision) {
        MappingItem connObjectKeyItem = MappingUtils.getConnObjectKeyItem((Provision)provision);
        if (connObjectKeyItem == null) {
            throw new NotFoundException("ConnObjectKey for " + any.getType() + " on resource '" + provision.getResource().getKey() + "'");
        }
        String connObjectKeyValue = this.mappingManager.getConnObjectKeyValue(any, provision);
        if (connObjectKeyValue == null) {
            return null;
        }
        HashSet<MappingItem> linkinMappingItems = new HashSet<MappingItem>();
        for (VirSchema virSchema : this.virSchemaDAO.findByProvision(provision)) {
            linkinMappingItems.add(virSchema.asLinkingMappingItem());
        }
        Iterator mapItems = IteratorUtils.chainedIterator(provision.getMapping().getItems().iterator(), linkinMappingItems.iterator());
        ConnObjectTO connObjectTO = null;
        Connector connector = this.connFactory.getConnector(provision.getResource());
        ConnectorObject connectorObject = connector.getObject(provision.getObjectClass(), AttributeBuilder.build((String)connObjectKeyItem.getExtAttrName(), (Object[])new Object[]{connObjectKeyValue}), MappingUtils.buildOperationOptions((Iterator)mapItems));
        if (connectorObject != null) {
            Set attributes = connectorObject.getAttributes();
            if (AttributeUtil.find((String)Uid.NAME, (Set)attributes) == null) {
                attributes.add(connectorObject.getUid());
            }
            if (AttributeUtil.find((String)Name.NAME, (Set)attributes) == null) {
                attributes.add(connectorObject.getName());
            }
            connObjectTO = ConnObjectUtils.getConnObjectTO((Set)attributes);
        }
        return connObjectTO;
    }

    @PreAuthorize(value="hasRole('RESOURCE_GET_CONNOBJECT')")
    public ReconStatus status(AnyTypeKind anyTypeKind, String anyKey, String resourceKey) {
        Pair<Any<?>, Provision> init = this.init(anyTypeKind, anyKey, resourceKey);
        ReconStatus status = new ReconStatus();
        status.setOnSyncope(this.getOnSyncope((Any)init.getLeft(), (Provision)init.getRight(), resourceKey));
        status.setOnResource(this.getOnResource((Any)init.getLeft(), (Provision)init.getRight()));
        return status;
    }

    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    public void push(AnyTypeKind anyTypeKind, String anyKey, String resourceKey, PushTaskTO pushTask) {
        Pair<Any<?>, Provision> init = this.init(anyTypeKind, anyKey, resourceKey);
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Reconciliation);
        try {
            List results = this.singlePushExecutor.push((Provision)init.getRight(), this.connFactory.getConnector(((Provision)init.getRight()).getResource()), (Any)init.getLeft(), pushTask);
            if (!results.isEmpty() && ((ProvisioningReport)results.get(0)).getStatus() == ProvisioningReport.Status.FAILURE) {
                sce.getElements().add(((ProvisioningReport)results.get(0)).getMessage());
            }
        }
        catch (JobExecutionException e) {
            sce.getElements().add(e.getMessage());
        }
        if (!sce.isEmpty()) {
            throw sce;
        }
    }

    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    public void pull(AnyTypeKind anyTypeKind, String anyKey, String resourceKey, PullTaskTO pullTask) {
        Pair<Any<?>, Provision> init = this.init(anyTypeKind, anyKey, resourceKey);
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Reconciliation);
        try {
            List results = this.singlePullExecutor.pull((Provision)init.getRight(), this.connFactory.getConnector(((Provision)init.getRight()).getResource()), ((Provision)init.getRight()).getMapping().getConnObjectKeyItem().getExtAttrName(), this.mappingManager.getConnObjectKeyValue((Any)init.getLeft(), (Provision)init.getRight()), ((Any)init.getLeft()).getRealm(), pullTask);
            if (!results.isEmpty() && ((ProvisioningReport)results.get(0)).getStatus() == ProvisioningReport.Status.FAILURE) {
                sce.getElements().add(((ProvisioningReport)results.get(0)).getMessage());
            }
        }
        catch (JobExecutionException e) {
            sce.getElements().add(e.getMessage());
        }
        if (!sce.isEmpty()) {
            throw sce;
        }
    }

    @Override
    protected AbstractBaseBean resolveReference(Method method, Object ... os) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

