/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.NotificationTO;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.lib.types.JobType;
import org.apache.syncope.core.logic.AbstractJobLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.entity.Notification;
import org.apache.syncope.core.provisioning.api.data.NotificationDataBinder;
import org.apache.syncope.core.provisioning.api.job.JobManager;
import org.apache.syncope.core.provisioning.java.job.notification.NotificationJob;
import org.quartz.JobKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class NotificationLogic
extends AbstractJobLogic<NotificationTO> {
    @Autowired
    private NotificationDAO notificationDAO;
    @Autowired
    private NotificationDataBinder binder;

    @PreAuthorize(value="hasRole('NOTIFICATION_READ')")
    @Transactional(readOnly=true)
    public NotificationTO read(String key) {
        Notification notification = this.notificationDAO.find(key);
        if (notification == null) {
            LOG.error("Could not find notification '" + key + "'");
            throw new NotFoundException(String.valueOf(key));
        }
        return this.binder.getNotificationTO(notification);
    }

    @PreAuthorize(value="hasRole('NOTIFICATION_LIST')")
    @Transactional(readOnly=true)
    public List<NotificationTO> list() {
        return (List)CollectionUtils.collect((Iterable)this.notificationDAO.findAll(), (Transformer)new Transformer<Notification, NotificationTO>(){

            public NotificationTO transform(Notification input) {
                return NotificationLogic.this.binder.getNotificationTO(input);
            }
        }, new ArrayList());
    }

    @PreAuthorize(value="hasRole('NOTIFICATION_CREATE')")
    public NotificationTO create(NotificationTO notificationTO) {
        return this.binder.getNotificationTO(this.notificationDAO.save(this.binder.create(notificationTO)));
    }

    @PreAuthorize(value="hasRole('NOTIFICATION_UPDATE')")
    public NotificationTO update(NotificationTO notificationTO) {
        Notification notification = this.notificationDAO.find(notificationTO.getKey());
        if (notification == null) {
            LOG.error("Could not find notification '" + notificationTO.getKey() + "'");
            throw new NotFoundException(String.valueOf(notificationTO.getKey()));
        }
        this.binder.update(notification, notificationTO);
        notification = this.notificationDAO.save(notification);
        return this.binder.getNotificationTO(notification);
    }

    @PreAuthorize(value="hasRole('NOTIFICATION_DELETE')")
    public NotificationTO delete(String key) {
        Notification notification = this.notificationDAO.find(key);
        if (notification == null) {
            LOG.error("Could not find notification '" + key + "'");
            throw new NotFoundException(String.valueOf(key));
        }
        NotificationTO deleted = this.binder.getNotificationTO(notification);
        this.notificationDAO.delete(key);
        return deleted;
    }

    @Override
    protected Triple<JobType, String, String> getReference(JobKey jobKey) {
        return JobManager.NOTIFICATION_JOB.equals((Object)jobKey) ? Triple.of((Object)JobType.NOTIFICATION, (Object)null, (Object)NotificationJob.class.getSimpleName()) : null;
    }

    @PreAuthorize(value="hasRole('NOTIFICATION_LIST')")
    public JobTO getJob() {
        List<JobTO> jobs = super.doListJobs(false);
        return jobs.isEmpty() ? null : jobs.get(0);
    }

    @PreAuthorize(value="hasRole('NOTIFICATION_EXECUTE')")
    public void actionJob(JobAction action) {
        super.doActionJob(JobManager.NOTIFICATION_JOB, action);
    }

    @Override
    protected NotificationTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof NotificationTO)) continue;
                key = ((NotificationTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getNotificationTO(this.notificationDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

