/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.content.ContentExporter;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.conf.CPlainAttr;
import org.apache.syncope.core.provisioning.api.data.ConfigurationDataBinder;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.workflow.api.AnyObjectWorkflowAdapter;
import org.apache.syncope.core.workflow.api.GroupWorkflowAdapter;
import org.apache.syncope.core.workflow.api.UserWorkflowAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ConfigurationLogic
extends AbstractTransactionalLogic<AttrTO> {
    @Autowired
    private ConfDAO confDAO;
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private ConfigurationDataBinder binder;
    @Autowired
    private ContentExporter exporter;
    @Autowired
    private UserWorkflowAdapter uwfAdapter;
    @Autowired
    private GroupWorkflowAdapter gwfAdapter;
    @Autowired
    private AnyObjectWorkflowAdapter awfAdapter;

    @PreAuthorize(value="hasRole('CONFIGURATION_DELETE')")
    public void delete(String schema) {
        PlainSchema plainSchema;
        CPlainAttr conf = this.confDAO.find(schema);
        if (conf == null && (plainSchema = (PlainSchema)this.plainSchemaDAO.find(schema)) == null) {
            throw new NotFoundException("Configuration schema " + schema);
        }
        this.confDAO.delete(schema);
    }

    @PreAuthorize(value="hasRole('CONFIGURATION_LIST')")
    @Transactional(readOnly=true)
    public List<AttrTO> list() {
        return this.binder.getConfTO();
    }

    @PreAuthorize(value="hasRole('CONFIGURATION_GET')")
    @Transactional(readOnly=true)
    public AttrTO get(String schema) {
        AttrTO result;
        CPlainAttr conf = this.confDAO.find(schema);
        if (conf == null) {
            PlainSchema plainSchema = (PlainSchema)this.plainSchemaDAO.find(schema);
            if (plainSchema == null) {
                throw new NotFoundException("Configuration schema " + schema);
            }
            result = new AttrTO();
            result.setSchema(schema);
        } else {
            result = this.binder.getAttrTO(conf);
        }
        return result;
    }

    @PreAuthorize(value="hasRole('CONFIGURATION_SET')")
    public void set(AttrTO value) {
        this.confDAO.save(this.binder.getAttr(value));
    }

    @PreAuthorize(value="hasRole('CONFIGURATION_EXPORT')")
    @Transactional(readOnly=true)
    public void export(OutputStream os) {
        try {
            this.exporter.export(AuthContextUtils.getDomain(), os, this.uwfAdapter.getPrefix(), this.gwfAdapter.getPrefix(), this.awfAdapter.getPrefix());
            LOG.debug("Database content successfully exported");
        }
        catch (Exception e) {
            LOG.error("While exporting database content", (Throwable)e);
        }
    }

    @Override
    protected AttrTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

