/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AccessTokenTO;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.AccessToken;
import org.apache.syncope.core.provisioning.api.data.AccessTokenDataBinder;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.Encryptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AccessTokenLogic
extends AbstractTransactionalLogic<AccessTokenTO> {
    private static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    @Resource(name="anonymousUser")
    private String anonymousUser;
    @Autowired
    private AccessTokenDataBinder binder;
    @Autowired
    private AccessTokenDAO accessTokenDAO;

    private byte[] getAuthorities() {
        byte[] authorities = null;
        try {
            authorities = ENCRYPTOR.encode(POJOHelper.serialize((Object)AuthContextUtils.getAuthorities()), CipherAlgorithm.AES).getBytes();
        }
        catch (Exception e) {
            LOG.error("Could not fetch authorities", (Throwable)e);
        }
        return authorities;
    }

    @PreAuthorize(value="isAuthenticated()")
    public Pair<String, Date> login() {
        if (this.anonymousUser.equals(AuthContextUtils.getUsername())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add(this.anonymousUser + " cannot be granted an access token");
            throw sce;
        }
        return this.binder.create(AuthContextUtils.getUsername(), Collections.emptyMap(), this.getAuthorities(), false);
    }

    @PreAuthorize(value="isAuthenticated()")
    public Pair<String, Date> refresh() {
        AccessToken accessToken = this.accessTokenDAO.findByOwner(AuthContextUtils.getUsername());
        if (accessToken == null) {
            throw new NotFoundException("AccessToken for " + AuthContextUtils.getUsername());
        }
        return this.binder.update(accessToken, this.getAuthorities());
    }

    @PreAuthorize(value="isAuthenticated()")
    public void logout() {
        AccessToken accessToken = this.accessTokenDAO.findByOwner(AuthContextUtils.getUsername());
        if (accessToken == null) {
            throw new NotFoundException("AccessToken for " + AuthContextUtils.getUsername());
        }
        this.delete(accessToken.getKey());
    }

    @PreAuthorize(value="hasRole('ACCESS_TOKEN_LIST')")
    @Transactional(readOnly=true)
    public Pair<Integer, List<AccessTokenTO>> list(int page, int size, List<OrderByClause> orderByClauses) {
        Integer count = this.accessTokenDAO.count();
        List result = (List)CollectionUtils.collect((Iterable)this.accessTokenDAO.findAll(page, size, orderByClauses), (Transformer)new Transformer<AccessToken, AccessTokenTO>(){

            public AccessTokenTO transform(AccessToken input) {
                return AccessTokenLogic.this.binder.getAccessTokenTO(input);
            }
        }, new ArrayList());
        return Pair.of((Object)count, (Object)result);
    }

    @PreAuthorize(value="hasRole('ACCESS_TOKEN_DELETE')")
    public void delete(String key) {
        this.accessTokenDAO.delete(key);
    }

    @Override
    protected AccessTokenTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

