/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.StatusPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.rest.api.service.UserSelfService;
import org.apache.syncope.core.logic.SyncopeLogic;
import org.apache.syncope.core.logic.UserLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserSelfServiceImpl
extends AbstractServiceImpl
implements UserSelfService {
    @Autowired
    private UserLogic logic;
    @Autowired
    private SyncopeLogic syncopeLogic;

    public Response create(UserTO userTO, boolean storePassword) {
        if (!this.syncopeLogic.isSelfRegAllowed()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.DelegatedAdministration);
            sce.getElements().add("Self registration forbidden by configuration");
            throw sce;
        }
        ProvisioningResult created = this.logic.selfCreate(userTO, storePassword, this.isNullPriorityAsync());
        return this.createResponse(created);
    }

    public Response read() {
        Pair self = this.logic.selfRead();
        return Response.ok().header("X-Syncope-Key", (Object)((UserTO)self.getValue()).getKey()).header("X-Syncope-Entitlements", self.getKey()).entity(self.getValue()).build();
    }

    public Response update(UserPatch patch) {
        ProvisioningResult updated = this.logic.selfUpdate(patch, this.isNullPriorityAsync());
        return this.modificationResponse(updated);
    }

    public Response update(UserTO user) {
        Pair self = this.logic.selfRead();
        return this.update(AnyOperations.diff((UserTO)user, (UserTO)((UserTO)self.getValue()), (boolean)false));
    }

    public Response status(StatusPatch statusPatch) {
        ProvisioningResult updated = this.logic.selfStatus(statusPatch, this.isNullPriorityAsync());
        return this.modificationResponse(updated);
    }

    public Response delete() {
        ProvisioningResult deleted = this.logic.selfDelete(this.isNullPriorityAsync());
        return this.modificationResponse(deleted);
    }

    public Response mustChangePassword(String password) {
        ProvisioningResult updated = this.logic.mustChangePassword(password, this.isNullPriorityAsync());
        return this.modificationResponse(updated);
    }

    public void requestPasswordReset(String username, String securityAnswer) {
        if (!this.syncopeLogic.isPwdResetAllowed()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.DelegatedAdministration);
            sce.getElements().add("Password reset forbidden by configuration");
            throw sce;
        }
        this.logic.requestPasswordReset(username, securityAnswer);
    }

    public void confirmPasswordReset(String token, String password) {
        if (!this.syncopeLogic.isPwdResetAllowed()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.DelegatedAdministration);
            sce.getElements().add("Password reset forbidden by configuration");
            throw sce;
        }
        this.logic.confirmPasswordReset(token, password);
    }
}

