/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.asyncexecutor;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.activiti.engine.impl.asyncexecutor.AbstractAsyncJobExecutor;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncJobExecutor
extends AbstractAsyncJobExecutor {
    private static Logger log = LoggerFactory.getLogger(DefaultAsyncJobExecutor.class);
    protected int corePoolSize = 2;
    protected int maxPoolSize = 10;
    protected int queueSize = 100;
    protected BlockingQueue<Runnable> threadPoolQueue;
    protected ExecutorService executorService;
    protected long secondsToWaitOnShutdown = 60L;

    @Override
    protected boolean executeAsyncJob(Runnable runnable) {
        try {
            this.executorService.execute(runnable);
            return true;
        }
        catch (RejectedExecutionException e) {
            return false;
        }
    }

    @Override
    protected Runnable createRunnableForJob(JobEntity job) {
        return this.executeAsyncRunnableFactory.createExecuteAsyncRunnable(job, this.commandExecutor);
    }

    @Override
    protected void unlockJob(JobEntity job, CommandContext commandContext) {
        commandContext.getJobEntityManager().unacquireJob(job.getId());
    }

    @Override
    protected void startExecutingAsyncJobs() {
        if (this.threadPoolQueue == null) {
            log.info("Creating thread pool queue of size {}", (Object)this.queueSize);
            this.threadPoolQueue = new ArrayBlockingQueue<Runnable>(this.queueSize);
        }
        if (this.executorService == null) {
            log.info("Creating executor service with corePoolSize {}, maxPoolSize {} and keepAliveTime {}", new Object[]{this.corePoolSize, this.maxPoolSize, this.keepAliveTime});
            this.executorService = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.MILLISECONDS, this.threadPoolQueue);
        }
        this.startJobAcquisitionThread();
    }

    @Override
    protected void stopExecutingAsyncJobs() {
        this.stopJobAcquisitionThread();
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(this.secondsToWaitOnShutdown, TimeUnit.SECONDS)) {
                log.warn("Timeout during shutdown of async job executor. The current running jobs could not end within " + this.secondsToWaitOnShutdown + " seconds after shutdown operation.");
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while shutting down the async job executor. ", (Throwable)e);
        }
        this.executorService = null;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public long getSecondsToWaitOnShutdown() {
        return this.secondsToWaitOnShutdown;
    }

    public void setSecondsToWaitOnShutdown(long secondsToWaitOnShutdown) {
        this.secondsToWaitOnShutdown = secondsToWaitOnShutdown;
    }

    public BlockingQueue<Runnable> getThreadPoolQueue() {
        return this.threadPoolQueue;
    }

    public void setThreadPoolQueue(BlockingQueue<Runnable> threadPoolQueue) {
        this.threadPoolQueue = threadPoolQueue;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

