/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.SAML2IdPTO;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Api(tags={"SAML2IdP"}, authorizations={@Authorization(value="BasicAuthentication"), @Authorization(value="Bearer")})
@Path(value="saml2sp/identityProviders")
public interface SAML2IdPService
extends JAXRSService {
    @GET
    @Path(value="actionsClasses")
    @Produces(value={"application/json"})
    public Set<String> getActionsClasses();

    @GET
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<SAML2IdPTO> list();

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public SAML2IdPTO read(@PathParam(value="key") String var1);

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response importFromMetadata(@NotNull InputStream var1);

    @ApiImplicitParams(value={@ApiImplicitParam(name="key", paramType="path", dataType="string", value="IdP's key")})
    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @PUT
    @Path(value="{key}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void update(@NotNull SAML2IdPTO var1);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @DELETE
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete(@PathParam(value="key") String var1);
}

