/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPullTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPushTask;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.ProvisioningTaskCheck;
import org.apache.syncope.core.persistence.jpa.validation.entity.SchedTaskValidator;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.ReconciliationFilterBuilder;

public class ProvisioningTaskValidator
extends AbstractValidator<ProvisioningTaskCheck, ProvisioningTask> {
    private final SchedTaskValidator schedV = new SchedTaskValidator();

    public boolean isValid(ProvisioningTask task, ConstraintValidatorContext context) {
        boolean isValid = this.schedV.isValid((SchedTask)task, context);
        if (isValid) {
            boolean bl = isValid = task.getResource() != null;
            if (!isValid) {
                LOG.error("Resource is null");
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidProvisioningTask, "Resource cannot be null")).addPropertyNode("resource").addConstraintViolation();
            }
            if (!task.getActionsClassNames().isEmpty()) {
                for (String className : task.getActionsClassNames()) {
                    Class<?> actionsClass = null;
                    boolean isAssignable = false;
                    try {
                        actionsClass = Class.forName(className);
                        isAssignable = task instanceof JPAPullTask ? PullActions.class.isAssignableFrom(actionsClass) : (task instanceof JPAPushTask ? PushActions.class.isAssignableFrom(actionsClass) : false);
                    }
                    catch (Exception e) {
                        LOG.error("Invalid {} / {} specified", new Object[]{PushActions.class.getName(), PullActions.class.getName(), e});
                        isValid = false;
                    }
                    if (actionsClass != null && isAssignable) continue;
                    isValid = false;
                    context.disableDefaultConstraintViolation();
                    context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidProvisioningTask, "Invalid class name")).addPropertyNode("actionsClassName").addConstraintViolation();
                }
            }
            if (isValid && task instanceof PullTask && ((PullTask)task).getPullMode() == PullMode.FILTERED_RECONCILIATION) {
                Class<?> filterBuilderClass = null;
                boolean isAssignable = false;
                try {
                    filterBuilderClass = Class.forName(((PullTask)task).getReconciliationFilterBuilderClassName());
                    isAssignable = ReconciliationFilterBuilder.class.isAssignableFrom(filterBuilderClass);
                }
                catch (Exception e) {
                    LOG.error("Invalid {} specified", new Object[]{ReconciliationFilterBuilder.class.getName(), PullActions.class.getName(), e});
                    isValid = false;
                }
                if (filterBuilderClass == null || !isAssignable) {
                    isValid = false;
                    context.disableDefaultConstraintViolation();
                    context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidProvisioningTask, "Invalid class name")).addPropertyNode("reconciliationFilterBuilderClassName").addConstraintViolation();
                }
            }
        }
        return isValid;
    }
}

