/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.entity.Domain;
import org.apache.syncope.core.persistence.jpa.entity.AbstractProvidedKeyEntity;
import org.apache.syncope.core.persistence.jpa.validation.entity.DomainCheck;
import org.apache.syncope.core.spring.security.Encryptor;

@Entity
@Table(name="SyncopeDomain")
@DomainCheck
public class JPADomain
extends AbstractProvidedKeyEntity
implements Domain,
PersistenceCapable {
    private static final long serialVersionUID = -5891241943464285840L;
    public static final String TABLE = "SyncopeDomain";
    private static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    private String adminPwd;
    @Enumerated(value=EnumType.STRING)
    private CipherAlgorithm adminCipherAlgorithm;
    private static int pcInheritedFieldCount = AbstractProvidedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractProvidedKeyEntity;
    static /* synthetic */ Class class$Lorg$apache$syncope$common$lib$types$CipherAlgorithm;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$JPADomain;

    public String getAdminPwd() {
        return JPADomain.pcGetadminPwd(this);
    }

    public CipherAlgorithm getAdminCipherAlgorithm() {
        return JPADomain.pcGetadminCipherAlgorithm(this);
    }

    public void setPassword(String password, CipherAlgorithm cipherAlgoritm) {
        try {
            JPADomain.pcSetadminPwd(this, ENCRYPTOR.encode(password, cipherAlgoritm));
            JPADomain.pcSetadminCipherAlgorithm(this, cipherAlgoritm);
        }
        catch (Exception e) {
            LOG.error("Could not encode password", (Throwable)e);
            JPADomain.pcSetadminPwd(this, null);
        }
    }

    static {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractProvidedKeyEntity != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractProvidedKeyEntity : (class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractProvidedKeyEntity = JPADomain.class$("org.apache.syncope.core.persistence.jpa.entity.AbstractProvidedKeyEntity"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"adminCipherAlgorithm", "adminPwd"};
        Class[] classArray = new Class[2];
        Class clazz2 = class$Lorg$apache$syncope$common$lib$types$CipherAlgorithm != null ? class$Lorg$apache$syncope$common$lib$types$CipherAlgorithm : (class$Lorg$apache$syncope$common$lib$types$CipherAlgorithm = JPADomain.class$("org.apache.syncope.common.lib.types.CipherAlgorithm"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPADomain.class$("java.lang.String"));
        classArray[1] = clazz3;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26};
        Class clazz4 = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPADomain != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPADomain : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPADomain = JPADomain.class$("org.apache.syncope.core.persistence.jpa.entity.JPADomain"));
        PCRegistry.register((Class)clazz4, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPADomain", (PersistenceCapable)new JPADomain());
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1674154;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.adminCipherAlgorithm = null;
        this.adminPwd = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPADomain jPADomain = new JPADomain();
        if (bl) {
            jPADomain.pcClearFields();
        }
        jPADomain.pcStateManager = stateManager;
        jPADomain.pcCopyKeyFieldsFromObjectId(object);
        return jPADomain;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPADomain jPADomain = new JPADomain();
        if (bl) {
            jPADomain.pcClearFields();
        }
        jPADomain.pcStateManager = stateManager;
        return jPADomain;
    }

    protected static int pcGetManagedFieldCount() {
        return 2 + AbstractProvidedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.adminCipherAlgorithm = (CipherAlgorithm)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.adminPwd = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.adminCipherAlgorithm);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.adminPwd);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JPADomain jPADomain, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPADomain, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.adminCipherAlgorithm = jPADomain.adminCipherAlgorithm;
                return;
            }
            case 1: {
                this.adminPwd = jPADomain.adminPwd;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPADomain jPADomain = (JPADomain)object;
        if (jPADomain.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jPADomain, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPADomain != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPADomain : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPADomain = JPADomain.class$("org.apache.syncope.core.persistence.jpa.entity.JPADomain"));
        return clazz;
    }

    private static final CipherAlgorithm pcGetadminCipherAlgorithm(JPADomain jPADomain) {
        if (jPADomain.pcStateManager == null) {
            return jPADomain.adminCipherAlgorithm;
        }
        int n = pcInheritedFieldCount + 0;
        jPADomain.pcStateManager.accessingField(n);
        return jPADomain.adminCipherAlgorithm;
    }

    private static final void pcSetadminCipherAlgorithm(JPADomain jPADomain, CipherAlgorithm cipherAlgorithm) {
        if (jPADomain.pcStateManager == null) {
            jPADomain.adminCipherAlgorithm = cipherAlgorithm;
            return;
        }
        jPADomain.pcStateManager.settingObjectField((PersistenceCapable)jPADomain, pcInheritedFieldCount + 0, (Object)jPADomain.adminCipherAlgorithm, (Object)cipherAlgorithm, 0);
    }

    private static final String pcGetadminPwd(JPADomain jPADomain) {
        if (jPADomain.pcStateManager == null) {
            return jPADomain.adminPwd;
        }
        int n = pcInheritedFieldCount + 1;
        jPADomain.pcStateManager.accessingField(n);
        return jPADomain.adminPwd;
    }

    private static final void pcSetadminPwd(JPADomain jPADomain, String string) {
        if (jPADomain.pcStateManager == null) {
            jPADomain.adminPwd = string;
            return;
        }
        jPADomain.pcStateManager.settingStringField((PersistenceCapable)jPADomain, pcInheritedFieldCount + 1, jPADomain.adminPwd, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

