/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.syncope.common.lib.patch.AnyObjectPatch;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.GroupPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.entity.AbstractPlainAttr;
import org.apache.syncope.core.persistence.jpa.entity.AbstractPlainAttrValue;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAAPlainAttr;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAAPlainAttrUniqueValue;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAAPlainAttrValue;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAAnyObject;
import org.apache.syncope.core.persistence.jpa.entity.group.JPAGPlainAttr;
import org.apache.syncope.core.persistence.jpa.entity.group.JPAGPlainAttrUniqueValue;
import org.apache.syncope.core.persistence.jpa.entity.group.JPAGPlainAttrValue;
import org.apache.syncope.core.persistence.jpa.entity.group.JPAGroup;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUPlainAttr;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUPlainAttrUniqueValue;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUPlainAttrValue;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class JPAAnyUtils
implements AnyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AnyUtils.class);
    private static final Set<String> USER_FIELD_NAMES = new HashSet<String>();
    private static final Set<String> GROUP_FIELD_NAMES = new HashSet<String>();
    private static final Set<String> ANY_OBJECT_FIELD_NAMES = new HashSet<String>();
    private final AnyTypeKind anyTypeKind;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private AnyObjectDAO anyObjectDAO;

    private static void initFieldNames(Class<?> entityClass, Set<String> keys) {
        List classes = ClassUtils.getAllSuperclasses(entityClass);
        classes.add(entityClass);
        for (Class clazz : classes) {
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || field.getName().startsWith("pc") || Collection.class.isAssignableFrom(field.getType()) || Map.class.isAssignableFrom(field.getType())) continue;
                keys.add("id".equals(field.getName()) ? "key" : field.getName());
            }
        }
    }

    public static boolean matchesFieldName(String candidate) {
        return USER_FIELD_NAMES.contains(candidate) || GROUP_FIELD_NAMES.contains(candidate) || ANY_OBJECT_FIELD_NAMES.contains(candidate);
    }

    protected JPAAnyUtils(AnyTypeKind typeKind) {
        this.anyTypeKind = typeKind;
    }

    public AnyTypeKind anyTypeKind() {
        return this.anyTypeKind;
    }

    public <T extends Any<?>> Class<T> anyClass() {
        Class result;
        switch (this.anyTypeKind) {
            case GROUP: {
                result = JPAGroup.class;
                break;
            }
            case ANY_OBJECT: {
                result = JPAAnyObject.class;
                break;
            }
            default: {
                result = JPAUser.class;
            }
        }
        return result;
    }

    public boolean isFieldName(String name) {
        Set<String> names;
        switch (this.anyTypeKind) {
            case GROUP: {
                names = GROUP_FIELD_NAMES;
                break;
            }
            case ANY_OBJECT: {
                names = ANY_OBJECT_FIELD_NAMES;
                break;
            }
            default: {
                names = USER_FIELD_NAMES;
            }
        }
        return names.contains(name);
    }

    public <T extends PlainAttr<?>> Class<T> plainAttrClass() {
        Class result;
        switch (this.anyTypeKind) {
            case GROUP: {
                result = JPAGPlainAttr.class;
                break;
            }
            case ANY_OBJECT: {
                result = JPAAPlainAttr.class;
                break;
            }
            default: {
                result = JPAUPlainAttr.class;
            }
        }
        return result;
    }

    public <T extends PlainAttr<?>> T newPlainAttr() {
        AbstractPlainAttr result = null;
        switch (this.anyTypeKind) {
            case USER: {
                result = new JPAUPlainAttr();
                break;
            }
            case GROUP: {
                result = new JPAGPlainAttr();
                break;
            }
            case ANY_OBJECT: {
                result = new JPAAPlainAttr();
                break;
            }
        }
        return (T)result;
    }

    public <T extends PlainAttrValue> Class<T> plainAttrValueClass() {
        Class result;
        switch (this.anyTypeKind) {
            case GROUP: {
                result = JPAGPlainAttrValue.class;
                break;
            }
            case ANY_OBJECT: {
                result = JPAAPlainAttrValue.class;
                break;
            }
            default: {
                result = JPAUPlainAttrValue.class;
            }
        }
        return result;
    }

    public <T extends PlainAttrValue> T newPlainAttrValue() {
        AbstractPlainAttrValue result = null;
        switch (this.anyTypeKind) {
            case USER: {
                result = new JPAUPlainAttrValue();
                break;
            }
            case GROUP: {
                result = new JPAGPlainAttrValue();
                break;
            }
            case ANY_OBJECT: {
                result = new JPAAPlainAttrValue();
                break;
            }
        }
        return (T)result;
    }

    public <T extends PlainAttrValue> Class<T> plainAttrUniqueValueClass() {
        Class result;
        switch (this.anyTypeKind) {
            case GROUP: {
                result = JPAGPlainAttrUniqueValue.class;
                break;
            }
            case ANY_OBJECT: {
                result = JPAAPlainAttrUniqueValue.class;
                break;
            }
            default: {
                result = JPAUPlainAttrUniqueValue.class;
            }
        }
        return result;
    }

    public <T extends PlainAttrValue> T newPlainAttrUniqueValue() {
        AbstractPlainAttrValue result = null;
        switch (this.anyTypeKind) {
            case USER: {
                result = new JPAUPlainAttrUniqueValue();
                break;
            }
            case GROUP: {
                result = new JPAGPlainAttrUniqueValue();
                break;
            }
            case ANY_OBJECT: {
                result = new JPAAPlainAttrUniqueValue();
                break;
            }
        }
        return (T)result;
    }

    public <T extends PlainAttrValue> T clonePlainAttrValue(T src) {
        T dst = src instanceof PlainAttrUniqueValue ? this.newPlainAttrUniqueValue() : this.newPlainAttrValue();
        dst.setBinaryValue(src.getBinaryValue());
        dst.setBooleanValue(src.getBooleanValue());
        dst.setDateValue(src.getDateValue());
        dst.setDoubleValue(src.getDoubleValue());
        dst.setLongValue(src.getLongValue());
        dst.setStringValue(src.getStringValue());
        return dst;
    }

    public <T extends AnyTO> T newAnyTO() {
        UserTO result = null;
        switch (this.anyTypeKind) {
            case USER: {
                result = new UserTO();
                break;
            }
            case GROUP: {
                result = new GroupTO();
                break;
            }
            case ANY_OBJECT: {
                result = new AnyObjectTO();
                break;
            }
        }
        return (T)result;
    }

    public <P extends AnyPatch> P newAnyPatch(String key) {
        UserPatch result = null;
        switch (this.anyTypeKind) {
            case USER: {
                result = new UserPatch();
                break;
            }
            case GROUP: {
                result = new GroupPatch();
                break;
            }
            case ANY_OBJECT: {
                result = new AnyObjectPatch();
                break;
            }
        }
        if (result != null) {
            result.setKey(key);
        }
        return (P)result;
    }

    public <A extends Any<?>> AnyDAO<A> dao() {
        UserDAO result = null;
        switch (this.anyTypeKind) {
            case USER: {
                result = this.userDAO;
                break;
            }
            case GROUP: {
                result = this.groupDAO;
                break;
            }
            case ANY_OBJECT: {
                result = this.anyObjectDAO;
                break;
            }
        }
        return result;
    }

    @Transactional(readOnly=true)
    public Set<ExternalResource> getAllResources(Any<?> any) {
        HashSet<ExternalResource> resources = new HashSet<ExternalResource>();
        if (any instanceof User) {
            resources.addAll(this.userDAO.findAllResources((User)any));
        } else if (any instanceof Group) {
            resources.addAll(((Group)any).getResources());
        } else if (any instanceof AnyObject) {
            resources.addAll(this.anyObjectDAO.findAllResources((AnyObject)any));
        }
        return resources;
    }

    static {
        JPAAnyUtils.initFieldNames(JPAUser.class, USER_FIELD_NAMES);
        JPAAnyUtils.initFieldNames(JPAGroup.class, GROUP_FIELD_NAMES);
        JPAAnyUtils.initFieldNames(JPAAnyObject.class, ANY_OBJECT_FIELD_NAMES);
    }
}

