/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Query;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.Notification;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.task.AbstractTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPANotificationTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPropagationTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPullTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPushTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPASchedTask;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

@Repository
public class JPATaskDAO
extends AbstractDAO<Task>
implements TaskDAO {
    public Class<? extends Task> getEntityReference(TaskType type) {
        Class result = null;
        switch (type) {
            case NOTIFICATION: {
                result = JPANotificationTask.class;
                break;
            }
            case PROPAGATION: {
                result = JPAPropagationTask.class;
                break;
            }
            case PUSH: {
                result = JPAPushTask.class;
                break;
            }
            case SCHEDULED: {
                result = JPASchedTask.class;
                break;
            }
            case PULL: {
                result = JPAPullTask.class;
                break;
            }
        }
        return result;
    }

    private String getEntityTableName(TaskType type) {
        String result = null;
        switch (type) {
            case NOTIFICATION: {
                result = JPANotificationTask.class.getAnnotation(DiscriminatorValue.class).value();
                break;
            }
            case PROPAGATION: {
                result = JPAPropagationTask.class.getAnnotation(DiscriminatorValue.class).value();
                break;
            }
            case PUSH: {
                result = JPAPushTask.class.getAnnotation(DiscriminatorValue.class).value();
                break;
            }
            case SCHEDULED: {
                result = JPASchedTask.class.getAnnotation(DiscriminatorValue.class).value();
                break;
            }
            case PULL: {
                result = JPAPullTask.class.getAnnotation(DiscriminatorValue.class).value();
                break;
            }
        }
        return result;
    }

    @Transactional(readOnly=true)
    public <T extends Task> T find(String key) {
        return (T)((Task)this.entityManager().find(AbstractTask.class, (Object)key));
    }

    private <T extends Task> StringBuilder buildFindAllQueryJPA(TaskType type) {
        StringBuilder builder = new StringBuilder("SELECT t FROM ").append(this.getEntityReference(type).getSimpleName()).append(" t WHERE ");
        if (type == TaskType.SCHEDULED) {
            builder.append("t.id NOT IN (SELECT t.id FROM ").append(JPAPushTask.class.getSimpleName()).append(" t) ").append("AND ").append("t.id NOT IN (SELECT t.id FROM ").append(JPAPullTask.class.getSimpleName()).append(" t)");
        } else {
            builder.append("1=1");
        }
        return builder.append(' ');
    }

    public <T extends Task> List<T> findToExec(TaskType type) {
        StringBuilder queryString = this.buildFindAllQueryJPA(type).append("AND ");
        if (type == TaskType.NOTIFICATION) {
            queryString.append("t.executed = 0 ");
        } else {
            queryString.append("t.executions IS EMPTY ");
        }
        queryString.append("ORDER BY t.id DESC");
        Query query = this.entityManager().createQuery(queryString.toString());
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public <T extends Task> List<T> findAll(TaskType type) {
        return this.findAll(type, null, null, null, null, -1, -1, Collections.emptyList());
    }

    private StringBuilder buildFindAllQuery(TaskType type, ExternalResource resource, Notification notification, AnyTypeKind anyTypeKind, String entityKey, boolean orderByTaskExecInfo, List<Object> queryParameters) {
        if (resource != null && type != TaskType.PROPAGATION && type != TaskType.PUSH && type != TaskType.PULL) {
            throw new IllegalArgumentException(type + " is not related to " + ExternalResource.class.getSimpleName());
        }
        if ((anyTypeKind != null || entityKey != null) && type != TaskType.PROPAGATION && type != TaskType.NOTIFICATION) {
            throw new IllegalArgumentException(type + " is not related to users, groups or any objects");
        }
        if (notification != null && type != TaskType.NOTIFICATION) {
            throw new IllegalArgumentException(type + " is not related to notifications");
        }
        StringBuilder queryString = new StringBuilder("SELECT ").append("Task").append(".id FROM ").append("Task");
        if (orderByTaskExecInfo) {
            queryString.append(" LEFT OUTER JOIN ").append("TaskExec").append(" ON ").append("Task").append(".id = ").append("TaskExec").append(".task_id");
        }
        queryString.append(" WHERE ").append("Task").append(".DTYPE = ?1");
        queryParameters.add(this.getEntityTableName(type));
        if (type == TaskType.SCHEDULED) {
            queryString.append(" AND ").append("Task").append(".id NOT IN (SELECT ").append("Task").append(".id FROM ").append("Task").append(" WHERE ").append("Task").append(".DTYPE = ?2)").append(" AND ").append("Task").append(".id NOT IN (SELECT id FROM ").append("Task").append(" WHERE ").append("Task").append(".DTYPE = ?3)");
            queryParameters.add(JPAPushTask.class.getAnnotation(DiscriminatorValue.class).value());
            queryParameters.add(JPAPullTask.class.getAnnotation(DiscriminatorValue.class).value());
        }
        queryString.append(' ');
        if (resource != null) {
            queryParameters.add(resource.getKey());
            queryString.append(" AND ").append("Task").append(".resource_id=?").append(queryParameters.size());
        }
        if (notification != null) {
            queryParameters.add(notification.getKey());
            queryString.append(" AND ").append("Task").append(".notification_id=?").append(queryParameters.size());
        }
        if (anyTypeKind != null && entityKey != null) {
            queryParameters.add(anyTypeKind.name());
            queryParameters.add(entityKey);
            queryString.append(" AND ").append("Task").append(".anyTypeKind=?").append(queryParameters.size() - 1).append(" AND ").append("Task").append(".entityKey=?").append(queryParameters.size());
        }
        return queryString;
    }

    private String toOrderByStatement(Class<? extends Task> beanClass, List<OrderByClause> orderByClauses, boolean orderByTaskExecInfo) {
        StringBuilder statement = new StringBuilder();
        if (orderByTaskExecInfo) {
            statement.append(" AND (").append("TaskExec").append(".startDate IS NULL OR ").append("TaskExec").append(".startDate = (SELECT MAX(").append("TaskExec").append(".startDate) FROM ").append("TaskExec").append(" WHERE ").append("Task").append(".id = ").append("TaskExec").append(".task_id))");
        }
        statement.append(" ORDER BY ");
        StringBuilder subStatement = new StringBuilder();
        for (OrderByClause clause : orderByClauses) {
            String field = clause.getField().trim();
            String table = "TaskExec";
            switch (field) {
                case "latestExecStatus": {
                    field = "status";
                    break;
                }
                case "start": {
                    field = "startDate";
                    break;
                }
                case "end": {
                    field = "endDate";
                    break;
                }
                default: {
                    Field beanField = ReflectionUtils.findField(beanClass, (String)field);
                    if (beanField != null && (beanField.getAnnotation(ManyToOne.class) != null || beanField.getAnnotation(OneToMany.class) != null)) {
                        field = field + "_id";
                    }
                    table = "Task";
                }
            }
            subStatement.append(table).append(".").append(field).append(' ').append(clause.getDirection().name()).append(',');
        }
        if (subStatement.length() == 0) {
            statement.append("Task").append(".id DESC");
        } else {
            subStatement.deleteCharAt(subStatement.length() - 1);
            statement.append((CharSequence)subStatement);
        }
        return statement.toString();
    }

    public <T extends Task> List<T> findAll(TaskType type, ExternalResource resource, Notification notification, AnyTypeKind anyTypeKind, String entityKey, int page, int itemsPerPage, List<OrderByClause> orderByClauses) {
        ArrayList<Object> queryParameters = new ArrayList<Object>();
        boolean orderByTaskExecInfo = IterableUtils.matchesAny(orderByClauses, (Predicate)new Predicate<OrderByClause>(){

            public boolean evaluate(OrderByClause object) {
                return object.getField().equals("start") || object.getField().equals("end") || object.getField().equals("latestExecStatus") || object.getField().equals("status");
            }
        });
        StringBuilder queryString = this.buildFindAllQuery(type, resource, notification, anyTypeKind, entityKey, orderByTaskExecInfo, queryParameters).append(this.toOrderByStatement(this.getEntityReference(type), orderByClauses, orderByTaskExecInfo));
        Query query = this.entityManager().createNativeQuery(queryString.toString());
        for (int i = 1; i <= queryParameters.size(); ++i) {
            query.setParameter(i, queryParameters.get(i - 1));
        }
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage > 0) {
            query.setMaxResults(itemsPerPage);
        }
        return this.buildResult(query.getResultList());
    }

    public int count(TaskType type, ExternalResource resource, Notification notification, AnyTypeKind anyTypeKind, String entityKey) {
        ArrayList<Object> queryParameters = new ArrayList<Object>();
        StringBuilder queryString = this.buildFindAllQuery(type, resource, notification, anyTypeKind, entityKey, false, queryParameters);
        Query query = this.entityManager().createNativeQuery(StringUtils.replaceOnce((String)queryString.toString(), (String)"SELECT Task.id", (String)"SELECT COUNT(Task.id)"));
        for (int i = 1; i <= queryParameters.size(); ++i) {
            query.setParameter(i, queryParameters.get(i - 1));
        }
        return ((Number)query.getSingleResult()).intValue();
    }

    @Transactional(rollbackFor={Throwable.class})
    public <T extends Task> T save(T task) {
        return (T)((Task)this.entityManager().merge(task));
    }

    public void delete(String id) {
        Object task = this.find(id);
        if (task == null) {
            return;
        }
        this.delete((Task)task);
    }

    public void delete(Task task) {
        this.entityManager().remove((Object)task);
    }

    public void deleteAll(ExternalResource resource, TaskType type) {
        IterableUtils.forEach(this.findAll(type, resource, null, null, null, -1, -1, Collections.emptyList()), (Closure)new Closure<Task>(){

            public void execute(Task input) {
                JPATaskDAO.this.delete(input.getKey());
            }
        });
    }

    private <T extends Task> List<T> buildResult(List<Object> raw) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object anyKey : raw) {
            String actualKey = anyKey instanceof Object[] ? (String)((Object[])anyKey)[0] : (String)anyKey;
            T task = this.find(actualKey);
            if (task == null) {
                LOG.error("Could not find task with id {}, even if returned by native query", (Object)actualKey);
                continue;
            }
            if (result.contains(task)) continue;
            result.add(task);
        }
        return result;
    }
}

