/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Collection;
import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPADerSchema;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JPADerSchemaDAO
extends AbstractDAO<DerSchema>
implements DerSchemaDAO {
    @Autowired
    private ExternalResourceDAO resourceDAO;

    public DerSchema find(String key) {
        return (DerSchema)this.entityManager().find(JPADerSchema.class, (Object)key);
    }

    public List<DerSchema> findByAnyTypeClasses(Collection<AnyTypeClass> anyTypeClasses) {
        StringBuilder queryString = new StringBuilder("SELECT e FROM ").append(JPADerSchema.class.getSimpleName()).append(" e WHERE ");
        for (AnyTypeClass anyTypeClass : anyTypeClasses) {
            queryString.append("e.anyTypeClass.id='").append(anyTypeClass.getKey()).append("' OR ");
        }
        TypedQuery query = this.entityManager().createQuery(queryString.substring(0, queryString.length() - 4), DerSchema.class);
        return query.getResultList();
    }

    public List<DerSchema> findByKeyword(String keyword) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPADerSchema.class.getSimpleName() + " e WHERE e.id LIKE :keyword", DerSchema.class);
        query.setParameter("keyword", (Object)keyword);
        return query.getResultList();
    }

    public List<DerSchema> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPADerSchema.class.getSimpleName() + " e", DerSchema.class);
        return query.getResultList();
    }

    public DerSchema save(DerSchema derSchema) {
        return (DerSchema)this.entityManager().merge((Object)derSchema);
    }

    public void delete(String key) {
        DerSchema schema = this.find(key);
        if (schema == null) {
            return;
        }
        this.resourceDAO.deleteMapping(key);
        if (schema.getAnyTypeClass() != null) {
            schema.getAnyTypeClass().getDerSchemas().remove(schema);
        }
        this.entityManager().remove((Object)schema);
    }
}

