/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Collections;
import java.util.List;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.conf.CPlainAttr;
import org.apache.syncope.core.persistence.api.entity.conf.CPlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.conf.Conf;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.conf.JPAConf;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JPAConfDAO
extends AbstractDAO<Conf>
implements ConfDAO {
    private static final String KEY = "cd64d66f-6fff-4008-b966-a06b1cc1436d";

    public Conf get() {
        Conf instance = (Conf)this.entityManager().find(JPAConf.class, (Object)KEY);
        if (instance == null) {
            instance = new JPAConf();
            instance.setKey(KEY);
            instance = (Conf)this.entityManager().merge((Object)instance);
        }
        return instance;
    }

    @Transactional(readOnly=true)
    public CPlainAttr find(String key) {
        return (CPlainAttr)this.get().getPlainAttr(key);
    }

    @Transactional(readOnly=true)
    public List<String> getValuesAsStrings(String key) {
        CPlainAttr attr = this.find(key);
        return attr == null ? Collections.emptyList() : attr.getValuesAsStrings();
    }

    @Transactional(readOnly=true)
    public <T> T find(String key, T defaultValue) {
        CPlainAttr result = this.find(key);
        if (result == null) {
            return defaultValue;
        }
        return (T)(result.getUniqueValue() == null ? (result.getValues().isEmpty() ? null : ((CPlainAttrValue)result.getValues().get(0)).getValue()) : result.getUniqueValue().getValue());
    }

    public Conf save(CPlainAttr attr) {
        Conf instance = this.get();
        CPlainAttr old = (CPlainAttr)instance.getPlainAttr(attr.getSchema().getKey());
        if (!(old == null || attr.getSchema().isUniqueConstraint() && attr.getUniqueValue().getStringValue().equals(old.getUniqueValue().getStringValue()))) {
            old.setOwner(null);
            instance.remove((PlainAttr)old);
        }
        instance.add(attr);
        attr.setOwner((Any)instance);
        return (Conf)this.entityManager().merge((Object)instance);
    }

    public Conf delete(String key) {
        Conf instance = this.get();
        CPlainAttr attr = (CPlainAttr)instance.getPlainAttr(key);
        if (attr != null) {
            attr.setOwner(null);
            instance.remove((PlainAttr)attr);
            instance = (Conf)this.entityManager().merge((Object)instance);
        }
        return instance;
    }
}

