/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyType;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JPAAnyTypeDAO
extends AbstractDAO<AnyType>
implements AnyTypeDAO {
    @Transactional(readOnly=true)
    public AnyType find(String key) {
        return (AnyType)this.entityManager().find(JPAAnyType.class, (Object)key);
    }

    @Transactional(readOnly=true)
    public AnyType findUser() {
        return this.find(AnyTypeKind.USER.name());
    }

    @Transactional(readOnly=true)
    public AnyType findGroup() {
        return this.find(AnyTypeKind.GROUP.name());
    }

    public List<AnyType> findByTypeClass(AnyTypeClass anyTypeClass) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAAnyType.class.getSimpleName() + " e WHERE :anyTypeClass MEMBER OF e.classes", AnyType.class);
        query.setParameter("anyTypeClass", (Object)anyTypeClass);
        return query.getResultList();
    }

    public List<AnyType> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAAnyType.class.getSimpleName() + " e ", AnyType.class);
        return query.getResultList();
    }

    public AnyType save(AnyType anyType) {
        return (AnyType)this.entityManager().merge((Object)anyType);
    }

    public void delete(String key) {
        AnyType anyType = this.find(key);
        if (anyType == null) {
            return;
        }
        if (anyType.equals(this.findUser()) || anyType.equals(this.findGroup())) {
            throw new IllegalArgumentException(key + " cannot be deleted");
        }
        this.entityManager().remove((Object)anyType);
    }
}

