/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Collections;
import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.group.TypeExtension;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyTypeClass;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JPAAnyTypeClassDAO
extends AbstractDAO<AnyTypeClass>
implements AnyTypeClassDAO {
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private DerSchemaDAO derSchemaDAO;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private ExternalResourceDAO resourceDAO;

    public AnyTypeClass find(String key) {
        return (AnyTypeClass)this.entityManager().find(JPAAnyTypeClass.class, (Object)key);
    }

    public List<AnyTypeClass> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAAnyTypeClass.class.getSimpleName() + " e ", AnyTypeClass.class);
        return query.getResultList();
    }

    public AnyTypeClass save(AnyTypeClass anyTypeClass) {
        AnyTypeClass merge = (AnyTypeClass)this.entityManager().merge((Object)anyTypeClass);
        for (PlainSchema schema : merge.getPlainSchemas()) {
            schema.setAnyTypeClass(merge);
        }
        for (PlainSchema schema : merge.getDerSchemas()) {
            schema.setAnyTypeClass(merge);
        }
        for (PlainSchema schema : merge.getVirSchemas()) {
            schema.setAnyTypeClass(merge);
        }
        return merge;
    }

    public void delete(String key) {
        AnyTypeClass anyTypeClass = this.find(key);
        if (anyTypeClass == null) {
            return;
        }
        for (PlainSchema schema : this.plainSchemaDAO.findByAnyTypeClasses(Collections.singletonList(anyTypeClass))) {
            schema.setAnyTypeClass(null);
        }
        for (PlainSchema schema : this.derSchemaDAO.findByAnyTypeClasses(Collections.singletonList(anyTypeClass))) {
            schema.setAnyTypeClass(null);
        }
        for (PlainSchema schema : this.virSchemaDAO.findByAnyTypeClasses(Collections.singletonList(anyTypeClass))) {
            schema.setAnyTypeClass(null);
        }
        for (AnyType type : this.anyTypeDAO.findByTypeClass(anyTypeClass)) {
            type.getClasses().remove(anyTypeClass);
        }
        for (TypeExtension typeExt : this.groupDAO.findTypeExtensions(anyTypeClass)) {
            typeExt.getAuxClasses().remove(anyTypeClass);
            if (!typeExt.getAuxClasses().isEmpty()) continue;
            typeExt.getGroup().getTypeExtensions().remove(typeExt);
            typeExt.setGroup(null);
        }
        for (Provision provision : this.resourceDAO.findProvisionsByAuxClass(anyTypeClass)) {
            provision.getAuxClasses().remove(anyTypeClass);
        }
        this.entityManager().remove((Object)anyTypeClass);
    }
}

