/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.camel.producer;

import java.util.Collection;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.camel.producer.AbstractProducer;

public class ProvisionProducer
extends AbstractProducer {
    public ProvisionProducer(Endpoint endpoint, AnyTypeKind anyType) {
        super(endpoint, anyType);
    }

    public void process(Exchange exchange) throws Exception {
        String key = (String)exchange.getIn().getBody(String.class);
        List resources = (List)exchange.getProperty("resources", List.class);
        Boolean nullPriorityAsync = (Boolean)exchange.getProperty("nullPriorityAsync", Boolean.class);
        if (this.getAnyTypeKind() == AnyTypeKind.USER) {
            Boolean changePwd = (Boolean)exchange.getProperty("changePwd", Boolean.class);
            String password = (String)exchange.getProperty("password", String.class);
            UserPatch userPatch = new UserPatch();
            userPatch.setKey(key);
            userPatch.getResources().addAll(CollectionUtils.collect((Iterable)resources, (Transformer)new Transformer<String, StringPatchItem>(){

                public StringPatchItem transform(String resource) {
                    return (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value((Object)resource)).build();
                }
            }));
            if (changePwd.booleanValue()) {
                userPatch.setPassword((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().onSyncope(true).value((Object)password)).resources((Collection)resources).build());
            }
            PropagationByResource propByRes = new PropagationByResource();
            propByRes.addAll(ResourceOperation.UPDATE, (Collection)resources);
            WorkflowResult wfResult = new WorkflowResult((Object)ImmutablePair.of((Object)userPatch, (Object)null), propByRes, "update");
            List tasks = this.getPropagationManager().getUserUpdateTasks(wfResult, changePwd.booleanValue(), null);
            PropagationReporter propagationReporter = this.getPropagationTaskExecutor().execute((Collection)tasks, nullPriorityAsync.booleanValue());
            exchange.getOut().setBody((Object)propagationReporter.getStatuses());
        } else {
            PropagationByResource propByRes = new PropagationByResource();
            propByRes.addAll(ResourceOperation.UPDATE, (Collection)resources);
            AnyTypeKind anyTypeKind = AnyTypeKind.GROUP;
            if (this.getAnyTypeKind() != null) {
                anyTypeKind = this.getAnyTypeKind();
            }
            List tasks = this.getPropagationManager().getUpdateTasks(anyTypeKind, key, false, null, propByRes, null, null);
            PropagationReporter propagationReporter = this.getPropagationTaskExecutor().execute((Collection)tasks, nullPriorityAsync.booleanValue());
            exchange.getOut().setBody((Object)propagationReporter.getStatuses());
        }
    }
}

