/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.camel;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.component.metrics.routepolicy.MetricsRoutePolicyFactory;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.persistence.api.dao.CamelRouteDAO;
import org.apache.syncope.core.persistence.api.entity.CamelRoute;
import org.apache.syncope.core.provisioning.camel.CamelException;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SyncopeCamelContext {
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeCamelContext.class);
    @Autowired
    private CamelRouteDAO routeDAO;
    private SpringCamelContext camelContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CamelContext getCamelContext() {
        SyncopeCamelContext syncopeCamelContext = this;
        synchronized (syncopeCamelContext) {
            if (this.camelContext == null) {
                this.camelContext = (SpringCamelContext)ApplicationContextProvider.getBeanFactory().getBean(SpringCamelContext.class);
                this.camelContext.addRoutePolicyFactory((RoutePolicyFactory)new MetricsRoutePolicyFactory());
            }
            if (this.camelContext.getRoutes().isEmpty()) {
                List routes = this.routeDAO.findAll();
                LOG.debug("{} route(s) are going to be loaded ", (Object)routes.size());
                this.loadRouteDefinitions(CollectionUtils.collect((Iterable)routes, (Transformer)new Transformer<CamelRoute, String>(){

                    public String transform(CamelRoute input) {
                        return input.getContent();
                    }
                }));
            }
            return this.camelContext;
        }
    }

    private void loadRouteDefinitions(Collection<String> routes) {
        try {
            RoutesDefinition routeDefs = this.camelContext.loadRoutesDefinition(IOUtils.toInputStream((String)("<routes xmlns=\"http://camel.apache.org/schema/spring\">" + StringUtils.join((Object[])new Collection[]{routes}) + "</routes>"), (Charset)StandardCharsets.UTF_8));
            this.camelContext.addRouteDefinitions((Collection)routeDefs.getRoutes());
        }
        catch (Exception e) {
            LOG.error("While adding route definitions into Camel Context {}", (Object)this.camelContext, (Object)e);
            throw new CamelException(e);
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public void updateContext(String routeKey) {
        if (!this.camelContext.getRouteDefinitions().isEmpty()) {
            this.camelContext.getRouteDefinitions().remove(this.camelContext.getRouteDefinition(routeKey));
            this.loadRouteDefinitions(Arrays.asList(this.routeDAO.find(routeKey).getContent()));
        }
    }

    public void restoreRoute(String routeKey, String routeContent) {
        try {
            this.camelContext.getRouteDefinitions().remove(this.camelContext.getRouteDefinition(routeKey));
            this.loadRouteDefinitions(Arrays.asList(routeContent));
        }
        catch (Exception e) {
            LOG.error("While restoring Camel route {}", (Object)routeKey, (Object)e);
            throw new CamelException(e);
        }
    }

    public void restartContext() {
        try {
            this.camelContext.stop();
            this.camelContext.start();
        }
        catch (Exception e) {
            LOG.error("While restarting Camel context", (Throwable)e);
            throw new CamelException(e);
        }
    }
}

