/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.user;

import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.user.AbstractUserCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.BulkActionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDeleteByAttribute
extends AbstractUserCommand {
    private static final Logger LOG = LoggerFactory.getLogger(UserDeleteByAttribute.class);
    private static final String SEARCH_HELP_MESSAGE = "user --delete-by-attribute {REALM} {ATTR-NAME}={ATTR-VALUE}";
    private final Input input;

    public UserDeleteByAttribute(Input input) {
        this.input = input;
    }

    public void delete() {
        block10: {
            if (this.input.parameterNumber() == 2) {
                String realm = this.input.firstParameter();
                Pair<String, String> pairParameter = Input.toPairParameter(this.input.secondParameter());
                try {
                    if (!this.realmSyncopeOperations.exists(realm)) {
                        this.userResultManager.notFoundError("Realm", realm);
                        return;
                    }
                    Map<String, BulkActionResult.Status> results = this.userSyncopeOperations.deleteByAttribute(realm, (String)pairParameter.getKey(), (String)pairParameter.getValue());
                    HashMap<String, String> failedUsers = new HashMap<String, String>();
                    int deletedUsers = 0;
                    for (Map.Entry<String, BulkActionResult.Status> entrySet : results.entrySet()) {
                        String userId = entrySet.getKey();
                        BulkActionResult.Status status = entrySet.getValue();
                        if (BulkActionResult.Status.SUCCESS == status) {
                            ++deletedUsers;
                            continue;
                        }
                        failedUsers.put(userId, status.name());
                    }
                    this.userResultManager.genericMessage("Deleted users: " + deletedUsers);
                    if (!failedUsers.isEmpty()) {
                        this.userResultManager.printFailedUsers(failedUsers);
                    }
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error searching user", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.userResultManager.notFoundError("User with " + (String)pairParameter.getKey(), (String)pairParameter.getValue());
                        break block10;
                    }
                    this.userResultManager.genericError(ex.getMessage());
                }
                catch (IllegalArgumentException ex) {
                    LOG.error("Error searching user", (Throwable)ex);
                    this.userResultManager.genericError(ex.getMessage());
                    this.userResultManager.genericError(SEARCH_HELP_MESSAGE);
                }
            } else {
                this.userResultManager.commandOptionError(SEARCH_HELP_MESSAGE);
            }
        }
    }
}

