/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.user;

import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.user.AbstractUserCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.BulkActionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDeleteAll
extends AbstractUserCommand {
    private static final Logger LOG = LoggerFactory.getLogger(UserDeleteAll.class);
    private static final String DELETE_ALL_HELP_MESSAGE = "user --delete-all {REALM}";
    private final Input input;

    public UserDeleteAll(Input input) {
        this.input = input;
    }

    public void delete() {
        block12: {
            if (this.input.parameterNumber() == 1) {
                try {
                    Scanner scanIn = new Scanner(System.in);
                    System.out.println("\nRunning this operation you will delete all the realm users managed by Syncope, are you sure? [yes/no]");
                    String answer = scanIn.nextLine();
                    if ("yes".equalsIgnoreCase(answer)) {
                        System.out.println("\nUsername:");
                        String username = scanIn.nextLine();
                        System.out.println("\nPassword:");
                        String password = scanIn.nextLine();
                        if (this.userSyncopeOperations.auth(username, password)) {
                            System.out.println("Deleting process started");
                            String realm = this.input.firstParameter();
                            if (!this.realmSyncopeOperations.exists(realm)) {
                                this.userResultManager.notFoundError("Realm", realm);
                                return;
                            }
                            Map<String, BulkActionResult.Status> results = this.userSyncopeOperations.deleteAll(realm);
                            HashMap<String, String> users = new HashMap<String, String>();
                            int deletedUsers = 0;
                            for (Map.Entry<String, BulkActionResult.Status> entrySet : results.entrySet()) {
                                String userId = entrySet.getKey();
                                BulkActionResult.Status status = entrySet.getValue();
                                if (!BulkActionResult.Status.SUCCESS.equals((Object)status)) {
                                    users.put(userId, status.name());
                                    continue;
                                }
                                ++deletedUsers;
                            }
                            this.userResultManager.genericMessage("Deleted users: " + deletedUsers);
                            if (!users.isEmpty()) {
                                this.userResultManager.printFailedUsers(users);
                            }
                        } else {
                            this.userResultManager.genericError("Authentication error");
                        }
                        break block12;
                    }
                    if ("no".equalsIgnoreCase(answer)) {
                        this.userResultManager.genericError("Delete all operation skipped");
                        break block12;
                    }
                    this.userResultManager.genericError("Invalid parameter, please use [yes/no]");
                }
                catch (SyncopeClientException ex) {
                    LOG.error("Error deleting user", (Throwable)ex);
                    this.userResultManager.genericError(ex.getMessage());
                }
            } else {
                this.userResultManager.commandOptionError(DELETE_ALL_HELP_MESSAGE);
            }
        }
    }
}

