/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.self;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.self.AbstractWorkflowCommand;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowExportDefinition
extends AbstractWorkflowCommand {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowExportDefinition.class);
    private static final String EXPORT_HELP_MESSAGE = "workflow --export-definition {ANY-TYPE-KIND}\n";
    private final Input input;

    public WorkflowExportDefinition(Input input) {
        this.input = input;
    }

    public void export() {
        block6: {
            if (this.input.parameterNumber() == 1) {
                try {
                    this.workflowSyncopeOperations.exportDefinition(this.input.firstParameter());
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.workflowResultManager.notFoundError("Workflow", this.input.firstParameter());
                        break block6;
                    }
                    this.workflowResultManager.genericError(ex.getMessage());
                }
                catch (IllegalArgumentException ex) {
                    LOG.error("Error", (Throwable)ex);
                    this.workflowResultManager.typeNotValidError("workflow", this.input.firstParameter(), CommandUtils.fromEnumToArray(AnyTypeKind.class));
                }
            } else {
                this.workflowResultManager.commandOptionError(EXPORT_HELP_MESSAGE);
            }
        }
    }
}

