/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.resource;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.resource.AbstractResourceCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDetails
extends AbstractResourceCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceDetails.class);
    private static final String DETAILS_HELP_MESSAGE = "resource --details";
    private final Input input;

    public ResourceDetails(Input input) {
        this.input = input;
    }

    public void details() {
        if (this.input.parameterNumber() == 0) {
            try {
                LinkedMap details = new LinkedMap();
                List<ResourceTO> resourceTOs = this.resourceSyncopeOperations.list();
                details.put("Total number", String.valueOf(resourceTOs.size()));
                this.resourceResultManager.printDetails((Map<String, String>)details);
            }
            catch (SyncopeClientException ex) {
                LOG.error("Error reading details about resource", (Throwable)ex);
                this.resourceResultManager.genericError(ex.getMessage());
            }
        } else {
            this.resourceResultManager.unnecessaryParameters(this.input.listParameters(), DETAILS_HELP_MESSAGE);
        }
    }
}

