/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.policy;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.policy.PolicyDelete;
import org.apache.syncope.client.cli.commands.policy.PolicyDetails;
import org.apache.syncope.client.cli.commands.policy.PolicyList;
import org.apache.syncope.client.cli.commands.policy.PolicyRead;
import org.apache.syncope.client.cli.commands.policy.PolicyResultManager;

@Command(name="policy")
public class PolicyCommand
extends AbstractCommand {
    private final PolicyResultManager policyResultManager = new PolicyResultManager();

    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(PolicyOptions.HELP.getOptionName());
        }
        switch (PolicyOptions.fromName(input.getOption())) {
            case DETAILS: {
                new PolicyDetails(input).details();
                break;
            }
            case LIST: {
                new PolicyList(input).list();
                break;
            }
            case READ: {
                new PolicyRead(input).read();
                break;
            }
            case DELETE: {
                new PolicyDelete(input).delete();
                break;
            }
            case HELP: {
                System.out.println(this.getHelpMessage());
                break;
            }
            default: {
                this.policyResultManager.defaultOptionMessage(input.getOption(), this.getHelpMessage());
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return this.policyResultManager.commandHelpMessage(this.getClass());
    }

    public static enum PolicyOptions {
        HELP("--help"),
        DETAILS("--details"),
        LIST("--list"),
        READ("--read"),
        DELETE("--delete");

        private final String optionName;

        private PolicyOptions(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static PolicyOptions fromName(String name) {
            PolicyOptions optionToReturn = HELP;
            for (PolicyOptions option : PolicyOptions.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (PolicyOptions value : PolicyOptions.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

