/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.notification;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.notification.AbstractNotificationCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationDelete
extends AbstractNotificationCommand {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationDelete.class);
    private static final String DELETE_HELP_MESSAGE = "notification --delete {NOTIFICATION-KEY} {NOTIFICATION-KEY} [...]";
    private final Input input;

    public NotificationDelete(Input input) {
        this.input = input;
    }

    public void delete() {
        if (this.input.parameterNumber() >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.notificationSyncopeOperations.delete(parameter);
                    this.notificationResultManager.deletedMessage("Notification", parameter);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error deleting notification", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.notificationResultManager.notFoundError("Notification", parameter);
                        continue;
                    }
                    this.notificationResultManager.genericError(ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    this.notificationResultManager.notBooleanDeletedError("notification", parameter);
                }
            }
        } else {
            this.notificationResultManager.commandOptionError(DELETE_HELP_MESSAGE);
        }
    }
}

