/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.logger;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.logger.AbstractLoggerCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.log.LoggerTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerDetails
extends AbstractLoggerCommand {
    private static final Logger LOG = LoggerFactory.getLogger(LoggerDetails.class);
    private static final String LIST_HELP_MESSAGE = "logger --details";
    private final Input input;

    public LoggerDetails(Input input) {
        this.input = input;
    }

    public void details() {
        if (this.input.parameterNumber() == 0) {
            try {
                LinkedMap details = new LinkedMap();
                List<LoggerTO> loggerTOs = this.loggerSyncopeOperations.list();
                int debugLevel = 0;
                int errorLevel = 0;
                int fatalLevel = 0;
                int infoLevel = 0;
                int offLevel = 0;
                int traceLevel = 0;
                int warnLevel = 0;
                for (LoggerTO loggerTO : loggerTOs) {
                    switch (loggerTO.getLevel()) {
                        case DEBUG: {
                            ++debugLevel;
                            break;
                        }
                        case ERROR: {
                            ++errorLevel;
                            break;
                        }
                        case FATAL: {
                            ++fatalLevel;
                            break;
                        }
                        case INFO: {
                            ++infoLevel;
                            break;
                        }
                        case OFF: {
                            ++offLevel;
                            break;
                        }
                        case TRACE: {
                            ++traceLevel;
                            break;
                        }
                        case WARN: {
                            ++warnLevel;
                            break;
                        }
                    }
                }
                details.put("Total number", String.valueOf(loggerTOs.size()));
                details.put("Set to DEBUG", String.valueOf(debugLevel));
                details.put("Set to ERROR", String.valueOf(errorLevel));
                details.put("Set to FATAL", String.valueOf(fatalLevel));
                details.put("Set to INFO", String.valueOf(infoLevel));
                details.put("Set to OFF", String.valueOf(offLevel));
                details.put("Set to TRACE", String.valueOf(traceLevel));
                details.put("Set to WARN", String.valueOf(warnLevel));
                this.loggerResultManager.printDetails((Map<String, String>)details);
            }
            catch (SyncopeClientException ex) {
                LOG.error("Error reading details about logger", (Throwable)ex);
                this.loggerResultManager.genericError(ex.getMessage());
            }
        } else {
            this.loggerResultManager.unnecessaryParameters(this.input.listParameters(), LIST_HELP_MESSAGE);
        }
    }
}

