/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.connector;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.connector.AbstractConnectorCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorReadByResource
extends AbstractConnectorCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorReadByResource.class);
    private static final String READ_HELP_MESSAGE = "connector --read-by-resource {RESOURCE-KEY} {RESOURCE-KEY} [...]";
    private final Input input;

    public ConnectorReadByResource(Input input) {
        this.input = input;
    }

    public void read() {
        if (this.input.getParameters().length >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.connectorResultManager.printConnector(this.connectorSyncopeOperations.readByResource(parameter));
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error reading connector", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.connectorResultManager.notFoundError("Resource", parameter);
                        continue;
                    }
                    this.connectorResultManager.genericError(ex.getMessage());
                }
            }
        } else {
            this.connectorResultManager.commandOptionError(READ_HELP_MESSAGE);
        }
    }
}

