/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.impl.api.local.operations.SpiOperationLoggingUtil;
import org.identityconnectors.framework.spi.SearchResultsHandler;

public class SearchResultsHandlerLoggingProxy
implements SearchResultsHandler {
    private static final Log HANDLER_LOG = Log.getLog(SearchResultsHandler.class);
    private SearchResultsHandler origHandler;

    public SearchResultsHandlerLoggingProxy(SearchResultsHandler origHandler) {
        this.origHandler = origHandler;
    }

    public SearchResultsHandler getOrigHandler() {
        return this.origHandler;
    }

    public boolean handle(ConnectorObject connectorObject) {
        HANDLER_LOG.log(SearchResultsHandler.class, "handle", SpiOperationLoggingUtil.LOG_LEVEL, "Enter: handle(" + connectorObject + ")", null);
        try {
            boolean ret = this.origHandler.handle(connectorObject);
            HANDLER_LOG.log(SearchResultsHandler.class, "handle", SpiOperationLoggingUtil.LOG_LEVEL, "Return: " + ret, null);
            return ret;
        }
        catch (RuntimeException e) {
            SpiOperationLoggingUtil.logOpException(HANDLER_LOG, SearchResultsHandler.class, "handle", e);
            throw e;
        }
    }

    public void handleResult(SearchResult result) {
        HANDLER_LOG.log(SearchResultsHandler.class, "handleResult", SpiOperationLoggingUtil.LOG_LEVEL, "Enter: handleResult(" + result + ")", null);
        try {
            this.origHandler.handleResult(result);
            HANDLER_LOG.log(SearchResultsHandler.class, "handleResult", SpiOperationLoggingUtil.LOG_LEVEL, "Return", null);
        }
        catch (RuntimeException e) {
            SpiOperationLoggingUtil.logOpException(HANDLER_LOG, SearchResultsHandler.class, "handleResult", e);
            throw e;
        }
    }
}

