/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.ResultsHandlerConfiguration;
import org.identityconnectors.framework.api.operations.SearchApiOp;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.impl.api.local.operations.AttributesToGetResultsHandler;
import org.identityconnectors.framework.impl.api.local.operations.CaseNormalizer;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorAPIOperationRunner;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorOperationalContext;
import org.identityconnectors.framework.impl.api.local.operations.DuplicateFilteringResultsHandler;
import org.identityconnectors.framework.impl.api.local.operations.FilteredResultsHandler;
import org.identityconnectors.framework.impl.api.local.operations.NormalizingFilter;
import org.identityconnectors.framework.impl.api.local.operations.NormalizingResultsHandler;
import org.identityconnectors.framework.impl.api.local.operations.ObjectNormalizerFacade;
import org.identityconnectors.framework.impl.api.local.operations.SearchResultsHandlerLoggingProxy;
import org.identityconnectors.framework.impl.api.local.operations.SpiOperationLoggingUtil;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.identityconnectors.framework.spi.operations.SearchOp;

public class SearchImpl
extends ConnectorAPIOperationRunner
implements SearchApiOp {
    private static final Log logger = Log.getLog(SearchImpl.class);
    private static final Log OP_LOG = Log.getLog(SearchOp.class);

    public SearchImpl(ConnectorOperationalContext context, Connector connector) {
        super(context, connector);
    }

    public SearchResult search(ObjectClass objectClass, Filter originalFilter, ResultsHandler handler, OperationOptions options) {
        ObjectNormalizerFacade normalizer;
        Assertions.nullCheck((Object)objectClass, (String)"objectClass");
        if (ObjectClass.ALL.equals((Object)objectClass)) {
            throw new UnsupportedOperationException("Operation is not allowed on __ALL__ object class");
        }
        Assertions.nullCheck((Object)handler, (String)"handler");
        if (options == null) {
            options = new OperationOptionsBuilder().build();
        }
        SearchOp search = (SearchOp)this.getConnector();
        ResultsHandlerConfiguration hdlCfg = null != this.getOperationalContext() ? this.getOperationalContext().getResultsHandlerConfiguration() : new ResultsHandlerConfiguration();
        Object actualFilter = originalFilter;
        if (hdlCfg.isEnableFilteredResultsHandler() && hdlCfg.isEnableCaseInsensitiveFilter() && actualFilter != null) {
            logger.ok("Creating case insensitive filter", new Object[0]);
            normalizer = new ObjectNormalizerFacade(objectClass, new CaseNormalizer());
            actualFilter = new NormalizingFilter((Filter)actualFilter, normalizer);
        }
        if (hdlCfg.isEnableFilteredResultsHandler() && !hdlCfg.isFilteredResultsHandlerInValidationMode() && options.getPageSize() != null && options.getPageSize() > 0) {
            throw new IllegalArgumentException("Paged search is requested, but the filtered results handler is enabled in effective (i.e. non-validation) mode. This is not supported.");
        }
        if (hdlCfg.isEnableNormalizingResultsHandler()) {
            normalizer = this.getNormalizer(objectClass);
            NormalizingResultsHandler normalizingHandler = new NormalizingResultsHandler(handler, normalizer);
            if (hdlCfg.isEnableFilteredResultsHandler()) {
                Filter normalizedFilter = normalizer.normalizeFilter((Filter)actualFilter);
                handler = new FilteredResultsHandler(normalizingHandler, normalizedFilter, hdlCfg.isFilteredResultsHandlerInValidationMode());
                actualFilter = normalizedFilter;
            } else {
                handler = normalizingHandler;
            }
        } else if (hdlCfg.isEnableFilteredResultsHandler()) {
            handler = new FilteredResultsHandler(handler, (Filter)actualFilter, hdlCfg.isFilteredResultsHandlerInValidationMode());
        }
        String[] attrsToGet = options.getAttributesToGet();
        if (attrsToGet != null && attrsToGet.length > 0 && hdlCfg.isEnableAttributesToGetSearchResultsHandler()) {
            handler = this.getAttributesToGetResutlsHandler(handler, options);
        }
        final ResultsHandler handlerChain = handler;
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        SearchImpl.rawSearch(search, objectClass, actualFilter, new SearchResultsHandler(){

            public void handleResult(SearchResult searchResult) {
                result.set(searchResult);
            }

            public boolean handle(ConnectorObject connectorObject) {
                return handlerChain.handle(connectorObject);
            }
        }, options);
        return result.get();
    }

    public static void rawSearch(SearchOp<?> search, ObjectClass objectClass, Filter filter, SearchResultsHandler handler, OperationOptions options) {
        boolean eliminateDups;
        FilterTranslator translator = search.createFilterTranslator(objectClass, options);
        List queries = translator.translate(filter);
        if (SearchImpl.isLoggable()) {
            handler = new SearchResultsHandlerLoggingProxy(handler);
        }
        if (queries.size() == 0) {
            SearchImpl.logOpEntry(objectClass, null, handler, options);
            try {
                search.executeQuery(objectClass, null, (ResultsHandler)handler, options);
                SearchImpl.logOpExit();
            }
            catch (RuntimeException e) {
                SpiOperationLoggingUtil.logOpException(OP_LOG, SearchOp.class, "executeQuery", e);
                throw e;
            }
        }
        boolean bl = eliminateDups = queries.size() > 1;
        if (eliminateDups) {
            handler = new DuplicateFilteringResultsHandler(handler);
            if (options.getPageSize() != null && options.getPageSize() > 0) {
                throw new IllegalArgumentException("Paged search is requested, but the filter was translated into more than one query. This is not supported. Queries = " + queries);
            }
        }
        for (Object query : queries) {
            DuplicateFilteringResultsHandler h;
            SearchOp<?> hack = search;
            SearchImpl.logOpEntry(objectClass, query, handler, options);
            try {
                hack.executeQuery(objectClass, query, (ResultsHandler)handler, options);
                SearchImpl.logOpExit();
            }
            catch (RuntimeException e) {
                SpiOperationLoggingUtil.logOpException(OP_LOG, SearchOp.class, "executeQuery", e);
                throw e;
            }
            if (!(handler instanceof DuplicateFilteringResultsHandler) || (h = (DuplicateFilteringResultsHandler)handler).isStillHandling()) continue;
            break;
        }
    }

    private static boolean isLoggable() {
        return OP_LOG.isLoggable(SpiOperationLoggingUtil.LOG_LEVEL);
    }

    private static void logOpEntry(ObjectClass objectClass, Object object, SearchResultsHandler handler, OperationOptions options) {
        if (!SearchImpl.isLoggable()) {
            return;
        }
        StringBuilder bld = new StringBuilder();
        bld.append("Enter: executeQuery(");
        bld.append(objectClass).append(", ");
        bld.append(object).append(", ");
        if (handler instanceof SearchResultsHandlerLoggingProxy) {
            bld.append(((SearchResultsHandlerLoggingProxy)handler).getOrigHandler()).append(", ");
        } else {
            bld.append(handler).append(", ");
        }
        bld.append(options).append(")");
        String msg = bld.toString();
        OP_LOG.log(SearchOp.class, "executeQuery", SpiOperationLoggingUtil.LOG_LEVEL, msg, null);
    }

    private static void logOpExit() {
        if (!SearchImpl.isLoggable()) {
            return;
        }
        OP_LOG.log(SearchOp.class, "executeQuery", SpiOperationLoggingUtil.LOG_LEVEL, "Return", null);
    }

    private ResultsHandler getAttributesToGetResutlsHandler(ResultsHandler handler, OperationOptions options) {
        ResultsHandler ret = handler;
        String[] attrsToGet = options.getAttributesToGet();
        if (attrsToGet != null && attrsToGet.length > 0) {
            ret = new AttributesToGetSearchResultsHandler(handler, attrsToGet);
        }
        return ret;
    }

    public static class AttributesToGetSearchResultsHandler
    extends AttributesToGetResultsHandler
    implements ResultsHandler {
        private final ResultsHandler handler;

        public AttributesToGetSearchResultsHandler(ResultsHandler handler, String[] attrsToGet) {
            super(attrsToGet);
            Assertions.nullCheck((Object)handler, (String)"handler");
            this.handler = handler;
        }

        public boolean handle(ConnectorObject obj) {
            obj = this.reduceToAttrsToGet(obj);
            return this.handler.handle(obj);
        }
    }
}

