/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.identityconnectors.common.Pair;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.pooling.ObjectPoolConfiguration;
import org.identityconnectors.framework.api.ConnectorKey;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.serializer.SerializerUtil;
import org.identityconnectors.framework.impl.api.APIConfigurationImpl;
import org.identityconnectors.framework.impl.api.ConfigurationPropertiesImpl;
import org.identityconnectors.framework.impl.api.local.JavaClassProperties;
import org.identityconnectors.framework.impl.api.local.LocalConnectorInfoImpl;
import org.identityconnectors.framework.impl.api.local.ObjectPool;
import org.identityconnectors.framework.impl.api.local.ObjectPoolHandler;
import org.identityconnectors.framework.impl.api.local.ThreadClassLoaderManager;
import org.identityconnectors.framework.impl.api.local.operations.OperationalContext;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.PoolableConnector;

public class ConnectorPoolManager {
    private static final ConcurrentMap<ConnectorPoolKey, ObjectPool<PoolableConnector>> POOLS = new ConcurrentHashMap<ConnectorPoolKey, ObjectPool<PoolableConnector>>();
    private static final Log LOG = Log.getLog(ConnectorPoolManager.class);

    public static Pair<ConnectorPoolKey, ObjectPool<PoolableConnector>> getPool(APIConfigurationImpl impl, LocalConnectorInfoImpl localInfo) {
        try {
            return ConnectorPoolManager.getPool2(impl, localInfo);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static ObjectPool<PoolableConnector> getPool(ConnectorPoolKey connectorPoolKey) {
        return (ObjectPool)POOLS.get(connectorPoolKey);
    }

    private static Pair<ConnectorPoolKey, ObjectPool<PoolableConnector>> getPool2(APIConfigurationImpl impl, LocalConnectorInfoImpl localInfo) throws InstantiationException, IllegalAccessException {
        if (impl.isConnectorPoolingSupported()) {
            ConnectorPoolKey key = new ConnectorPoolKey(impl.getConnectorInfo().getConnectorKey(), impl.getConfigurationProperties(), impl.getConnectorPoolConfiguration());
            ObjectPool<PoolableConnector> pool = (ObjectPool<PoolableConnector>)POOLS.get(key);
            if (pool == null) {
                LOG.info("Creating new pool: {0}", new Object[]{impl.getConnectorInfo().getConnectorKey()});
                pool = new ObjectPool<PoolableConnector>(new ConnectorPoolHandler(impl, localInfo), impl.getConnectorPoolConfiguration());
                ObjectPool<PoolableConnector> previousPool = POOLS.putIfAbsent(key, pool);
                if (previousPool != null) {
                    pool = previousPool;
                }
            }
            return Pair.of((Object)key, (Object)pool);
        }
        if (!localInfo.isConfigurationStateless()) {
            return Pair.of((Object)new ConnectorPoolKey(impl.getConnectorInfo().getConnectorKey(), impl.getConfigurationProperties(), impl.getConnectorPoolConfiguration()), null);
        }
        return Pair.of(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose(ConnectorPoolKey connectorPoolKey) {
        ConcurrentMap<ConnectorPoolKey, ObjectPool<PoolableConnector>> concurrentMap = POOLS;
        synchronized (concurrentMap) {
            ObjectPool pool = (ObjectPool)POOLS.remove(connectorPoolKey);
            if (null != pool) {
                try {
                    pool.shutdown();
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e, "Failed to close pool: {0}", new Object[]{pool});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose() {
        ConcurrentMap<ConnectorPoolKey, ObjectPool<PoolableConnector>> concurrentMap = POOLS;
        synchronized (concurrentMap) {
            for (ObjectPool pool : POOLS.values()) {
                try {
                    pool.shutdown();
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e, "Failed to close pool: {0}", new Object[]{pool});
                }
            }
            POOLS.clear();
        }
    }

    private static class ConnectorPoolHandler
    implements ObjectPoolHandler<PoolableConnector> {
        private final APIConfigurationImpl apiConfiguration;
        private final LocalConnectorInfoImpl localConnectorInfo;
        private final OperationalContext context;

        public ConnectorPoolHandler(APIConfigurationImpl apiConfiguration, LocalConnectorInfoImpl localInfo) {
            this.apiConfiguration = apiConfiguration;
            this.localConnectorInfo = localInfo;
            this.context = this.localConnectorInfo.isConfigurationStateless() ? null : new OperationalContext(localInfo, apiConfiguration);
        }

        @Override
        public ObjectPoolConfiguration validate(ObjectPoolConfiguration original) {
            ObjectPoolConfiguration configuration = (ObjectPoolConfiguration)SerializerUtil.cloneObject((Object)original);
            configuration.validate();
            return configuration;
        }

        @Override
        public PoolableConnector makeObject() {
            ThreadClassLoaderManager.getInstance().pushClassLoader(this.localConnectorInfo.getConnectorClass().getClassLoader());
            try {
                Class<? extends Connector> clazz = this.localConnectorInfo.getConnectorClass();
                PoolableConnector connector = null;
                if (!PoolableConnector.class.isAssignableFrom(clazz)) {
                    throw new ConnectorException("The Connector is not PoolableConnector: " + this.localConnectorInfo.getConnectorKey());
                }
                Configuration config = null;
                config = null == this.context ? JavaClassProperties.createBean(this.apiConfiguration.getConfigurationProperties(), this.localConnectorInfo.getConnectorConfigurationClass()) : this.context.getConfiguration();
                connector = (PoolableConnector)clazz.newInstance();
                connector.init(config);
                PoolableConnector poolableConnector = connector;
                return poolableConnector;
            }
            catch (Exception e) {
                throw ConnectorException.wrap((Throwable)e);
            }
            finally {
                ThreadClassLoaderManager.getInstance().popClassLoader();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void testObject(PoolableConnector object) {
            ThreadClassLoaderManager.getInstance().pushClassLoader(this.localConnectorInfo.getConnectorClass().getClassLoader());
            try {
                object.checkAlive();
            }
            finally {
                ThreadClassLoaderManager.getInstance().popClassLoader();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disposeObject(PoolableConnector object) {
            ThreadClassLoaderManager.getInstance().pushClassLoader(this.localConnectorInfo.getConnectorClass().getClassLoader());
            try {
                object.dispose();
            }
            finally {
                ThreadClassLoaderManager.getInstance().popClassLoader();
            }
        }

        @Override
        public void shutdown() {
            if (null != this.context) {
                this.context.dispose();
            }
        }
    }

    public static class ConnectorPoolKey {
        private final ConnectorKey connectorKey;
        private final ConfigurationPropertiesImpl configProperties;
        private final ObjectPoolConfiguration poolingConfig;

        public ConnectorPoolKey(ConnectorKey connectorKey, ConfigurationPropertiesImpl configProperties, ObjectPoolConfiguration poolingConfig) {
            this.connectorKey = connectorKey;
            this.configProperties = configProperties;
            this.poolingConfig = poolingConfig;
        }

        public int hashCode() {
            return this.connectorKey.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof ConnectorPoolKey) {
                ConnectorPoolKey other = (ConnectorPoolKey)object;
                if (!this.connectorKey.equals((Object)other.connectorKey)) {
                    return false;
                }
                if (!this.configProperties.equals(other.configProperties)) {
                    return false;
                }
                return this.poolingConfig.equals((Object)other.poolingConfig);
            }
            return false;
        }
    }
}

