/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.impl.api.LoggingProxy;

public class ResultHandlerLoggingProxy
implements ResultsHandler {
    private static final Log LOG = Log.getLog(ResultHandlerLoggingProxy.class);
    private ResultsHandler origHandler;

    public ResultHandlerLoggingProxy(ResultsHandler origHandler) {
        this.origHandler = origHandler;
    }

    public ResultsHandler getOrigHandler() {
        return this.origHandler;
    }

    public boolean handle(ConnectorObject connectorObject) {
        LOG.log(ResultsHandler.class, "handle", LoggingProxy.LOG_LEVEL, "Enter: " + connectorObject, null);
        try {
            boolean ret = this.origHandler.handle(connectorObject);
            LOG.log(ResultsHandler.class, "handle", LoggingProxy.LOG_LEVEL, "Return: " + ret, null);
            return ret;
        }
        catch (RuntimeException e) {
            LOG.log(ResultsHandler.class, "handle", LoggingProxy.LOG_LEVEL, "Exception: ", (Throwable)e);
            throw e;
        }
    }
}

