/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.impl.api.ResultHandlerLoggingProxy;

public class LoggingProxy
implements InvocationHandler {
    static final Log.Level LOG_LEVEL = Log.Level.OK;
    private static final Log LOG = Log.getLog(LoggingProxy.class);
    private final Object target;
    private final Class<? extends APIOperation> op;

    public LoggingProxy(Class<? extends APIOperation> api, Object target) {
        this.op = api;
        this.target = target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke(this.target, args);
        }
        String methodName = method.getName();
        if (LoggingProxy.isLoggable()) {
            StringBuilder bld = new StringBuilder();
            bld.append("Enter: ").append(method.getName()).append('(');
            for (int i = 0; args != null && i < args.length; ++i) {
                Object arg;
                if (i != 0) {
                    bld.append(", ");
                }
                if ((arg = args[i]) instanceof ResultHandlerLoggingProxy) {
                    bld.append(((ResultHandlerLoggingProxy)arg).getOrigHandler());
                    continue;
                }
                bld.append(arg);
            }
            bld.append(')');
            String msg = bld.toString();
            LOG.log(this.op, methodName, LOG_LEVEL, msg, null);
        }
        try {
            Object ret = method.invoke(this.target, args);
            if (LoggingProxy.isLoggable()) {
                LOG.log(this.op, methodName, LOG_LEVEL, "Return: " + ret, null);
            }
            return ret;
        }
        catch (InvocationTargetException e) {
            Throwable root = e.getCause();
            try {
                LOG.log(this.op, methodName, LOG_LEVEL, "Exception: ", root);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (root instanceof RuntimeException) {
                throw (RuntimeException)root;
            }
            if (root instanceof Exception) {
                throw (Exception)root;
            }
            if (root instanceof Error) {
                throw (Error)root;
            }
            throw ConnectorException.wrap((Throwable)root);
        }
    }

    public static boolean isLoggable() {
        return LOG.isLoggable(LOG_LEVEL);
    }
}

