/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.security.impl;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.identityconnectors.common.security.Encryptor;

public class EncryptorImpl
implements Encryptor {
    private static final String ALGORITHM = "AES";
    private static final String FULL_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final byte[] DEFAULT_KEY_BYTES = new byte[]{35, 101, -121, 34, 89, 120, 84, 67, 100, 5, 106, -67, 52, -94, 52, 87};
    private static final byte[] DEFAULT_IV_BYTES = new byte[]{81, 101, 34, 35, 100, 5, 106, -66, 81, 101, 34, 35, 100, 5, 106, -66};
    private Key key;
    private IvParameterSpec iv;

    public EncryptorImpl(boolean defaultKey) {
        if (defaultKey) {
            this.key = new SecretKeySpec(DEFAULT_KEY_BYTES, ALGORITHM);
            this.iv = new IvParameterSpec(DEFAULT_IV_BYTES);
        } else {
            try {
                this.key = KeyGenerator.getInstance(ALGORITHM).generateKey();
                this.iv = new IvParameterSpec(DEFAULT_IV_BYTES);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public byte[] decrypt(byte[] bytes) {
        try {
            Cipher cipher = Cipher.getInstance(FULL_ALGORITHM);
            cipher.init(2, this.key, this.iv);
            return cipher.doFinal(bytes);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] encrypt(byte[] bytes) {
        try {
            Cipher cipher = Cipher.getInstance(FULL_ALGORITHM);
            cipher.init(1, this.key, this.iv);
            return cipher.doFinal(bytes);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

