/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.security;

import org.identityconnectors.common.security.Encryptor;
import org.identityconnectors.common.security.EncryptorFactory;
import org.identityconnectors.common.security.SecurityUtil;

public final class GuardedString {
    static Encryptor encryptor;
    private boolean readOnly;
    private boolean disposed;
    private byte[] encryptedBytes;
    private String base64SHA1Hash;

    public GuardedString() {
        this(new char[0]);
    }

    public GuardedString(char[] clearChars) {
        this.encryptChars(clearChars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void access(Accessor accessor) {
        this.checkNotDisposed();
        char[] clearChars = null;
        try {
            clearChars = this.decryptChars();
            accessor.access(clearChars);
        }
        finally {
            SecurityUtil.clear(clearChars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendChar(char c) {
        this.checkNotDisposed();
        this.checkWriteable();
        char[] clearChars = null;
        char[] clearChars2 = null;
        try {
            clearChars = this.decryptChars();
            clearChars2 = new char[clearChars.length + 1];
            System.arraycopy(clearChars, 0, clearChars2, 0, clearChars.length);
            clearChars2[clearChars2.length - 1] = c;
            this.encryptChars(clearChars2);
        }
        catch (Throwable throwable) {
            SecurityUtil.clear(clearChars);
            SecurityUtil.clear(clearChars2);
            throw throwable;
        }
        SecurityUtil.clear(clearChars);
        SecurityUtil.clear(clearChars2);
    }

    public void dispose() {
        SecurityUtil.clear(this.encryptedBytes);
        this.disposed = true;
    }

    public boolean isReadOnly() {
        this.checkNotDisposed();
        return this.readOnly;
    }

    public void makeReadOnly() {
        this.checkNotDisposed();
        this.readOnly = true;
    }

    public GuardedString copy() {
        this.checkNotDisposed();
        byte[] encryptedBytes2 = new byte[this.encryptedBytes.length];
        System.arraycopy(this.encryptedBytes, 0, encryptedBytes2, 0, this.encryptedBytes.length);
        GuardedString rv = new GuardedString();
        rv.encryptedBytes = encryptedBytes2;
        return rv;
    }

    public boolean verifyBase64SHA1Hash(String hash) {
        this.checkNotDisposed();
        return this.base64SHA1Hash.equals(hash);
    }

    private void checkWriteable() {
        if (this.readOnly) {
            throw new IllegalStateException("String is read-only");
        }
    }

    private void checkNotDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("String is disposed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] decryptChars() {
        byte[] clearBytes = null;
        try {
            clearBytes = this.decryptBytes();
            char[] cArray = SecurityUtil.bytesToChars(clearBytes);
            return cArray;
        }
        finally {
            SecurityUtil.clear(clearBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encryptChars(char[] chars) {
        byte[] clearBytes = null;
        try {
            clearBytes = SecurityUtil.charsToBytes(chars);
            this.encryptBytes(clearBytes);
        }
        finally {
            SecurityUtil.clear(clearBytes);
        }
    }

    private static synchronized Encryptor getEncryptor() {
        if (encryptor == null) {
            encryptor = EncryptorFactory.getInstance().newRandomEncryptor();
        }
        return encryptor;
    }

    static synchronized void setEncryptor(Encryptor encryptor) {
        GuardedString.encryptor = encryptor;
    }

    private byte[] decryptBytes() {
        Encryptor encryptor = GuardedString.getEncryptor();
        return encryptor.decrypt(this.encryptedBytes);
    }

    private void encryptBytes(byte[] bytes) {
        Encryptor encryptor = GuardedString.getEncryptor();
        byte[] newBytes = encryptor.encrypt(bytes);
        SecurityUtil.clear(this.encryptedBytes);
        this.encryptedBytes = newBytes;
        this.base64SHA1Hash = SecurityUtil.computeBase64SHA1Hash(bytes);
    }

    public boolean equals(Object o) {
        if (o instanceof GuardedString) {
            GuardedString other = (GuardedString)o;
            return this.base64SHA1Hash.equals(other.base64SHA1Hash);
        }
        return false;
    }

    public int hashCode() {
        return this.base64SHA1Hash.hashCode();
    }

    public static interface Accessor {
        public void access(char[] var1);
    }
}

