/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.security;

import org.identityconnectors.common.security.Encryptor;
import org.identityconnectors.common.security.EncryptorFactory;
import org.identityconnectors.common.security.SecurityUtil;

public final class GuardedByteArray {
    private static Encryptor encryptor;
    private boolean readOnly;
    private boolean disposed;
    private byte[] encryptedBytes;
    private String base64SHA1Hash;

    public GuardedByteArray() {
        this(new byte[0]);
    }

    public GuardedByteArray(byte[] clearBytes) {
        this.encryptBytes(clearBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void access(Accessor accessor) {
        this.checkNotDisposed();
        byte[] clearBytes = null;
        try {
            clearBytes = this.decryptBytes();
            accessor.access(clearBytes);
        }
        finally {
            SecurityUtil.clear(clearBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendByte(byte b) {
        this.checkNotDisposed();
        this.checkWriteable();
        byte[] clearBytes = null;
        byte[] clearBytes2 = null;
        try {
            clearBytes = this.decryptBytes();
            clearBytes2 = new byte[clearBytes.length + 1];
            System.arraycopy(clearBytes, 0, clearBytes2, 0, clearBytes.length);
            clearBytes2[clearBytes2.length - 1] = b;
            this.encryptBytes(clearBytes2);
        }
        catch (Throwable throwable) {
            SecurityUtil.clear(clearBytes);
            SecurityUtil.clear(clearBytes2);
            throw throwable;
        }
        SecurityUtil.clear(clearBytes);
        SecurityUtil.clear(clearBytes2);
    }

    public void dispose() {
        SecurityUtil.clear(this.encryptedBytes);
        this.disposed = true;
    }

    public boolean isReadOnly() {
        this.checkNotDisposed();
        return this.readOnly;
    }

    public void makeReadOnly() {
        this.checkNotDisposed();
        this.readOnly = true;
    }

    public GuardedByteArray copy() {
        this.checkNotDisposed();
        byte[] encryptedBytes2 = new byte[this.encryptedBytes.length];
        System.arraycopy(this.encryptedBytes, 0, encryptedBytes2, 0, this.encryptedBytes.length);
        GuardedByteArray rv = new GuardedByteArray();
        rv.encryptedBytes = encryptedBytes2;
        return rv;
    }

    public boolean verifyBase64SHA1Hash(String hash) {
        this.checkNotDisposed();
        return this.base64SHA1Hash.equals(hash);
    }

    private void checkWriteable() {
        if (this.readOnly) {
            throw new IllegalStateException("Byte array is read-only");
        }
    }

    private void checkNotDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("Byte array is disposed");
        }
    }

    private static synchronized Encryptor getEncryptor() {
        if (encryptor == null) {
            encryptor = EncryptorFactory.getInstance().newRandomEncryptor();
        }
        return encryptor;
    }

    static synchronized void setEncryptor(Encryptor encryptor) {
        GuardedByteArray.encryptor = encryptor;
    }

    private byte[] decryptBytes() {
        Encryptor encryptor = GuardedByteArray.getEncryptor();
        return encryptor.decrypt(this.encryptedBytes);
    }

    private void encryptBytes(byte[] bytes) {
        Encryptor encryptor = GuardedByteArray.getEncryptor();
        byte[] newBytes = encryptor.encrypt(bytes);
        SecurityUtil.clear(this.encryptedBytes);
        this.encryptedBytes = newBytes;
        this.base64SHA1Hash = SecurityUtil.computeBase64SHA1Hash(bytes);
    }

    public boolean equals(Object o) {
        if (o instanceof GuardedByteArray) {
            GuardedByteArray other = (GuardedByteArray)o;
            return this.base64SHA1Hash.equals(other.base64SHA1Hash);
        }
        return false;
    }

    public int hashCode() {
        return this.base64SHA1Hash.hashCode();
    }

    public static interface Accessor {
        public void access(byte[] var1);
    }
}

