/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.mod.AbstractAttributableMod;
import org.apache.syncope.common.mod.AbstractSubjectMod;
import org.apache.syncope.common.mod.AttributeMod;
import org.apache.syncope.common.mod.MembershipMod;
import org.apache.syncope.common.mod.ReferenceMod;
import org.apache.syncope.common.mod.RoleMod;
import org.apache.syncope.common.mod.UserMod;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.AbstractSubjectTO;
import org.apache.syncope.common.to.AttributeTO;
import org.apache.syncope.common.to.MembershipTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.to.UserTO;

public final class AttributableOperations {
    private AttributableOperations() {
    }

    private static void populate(Map<String, AttributeTO> updatedAttrs, Map<String, AttributeTO> originalAttrs, AbstractAttributableMod result) {
        AttributableOperations.populate(updatedAttrs, originalAttrs, result, false);
    }

    private static void populate(Map<String, AttributeTO> updatedAttrs, Map<String, AttributeTO> originalAttrs, AbstractAttributableMod result, boolean virtuals) {
        for (Map.Entry<String, AttributeTO> entry : updatedAttrs.entrySet()) {
            HashSet<String> originalValues;
            AttributeMod mod = new AttributeMod();
            mod.setSchema(entry.getKey());
            HashSet<String> updatedValues = new HashSet<String>(entry.getValue().getValues());
            HashSet<String> hashSet = originalValues = originalAttrs.containsKey(entry.getKey()) ? new HashSet<String>(originalAttrs.get(entry.getKey()).getValues()) : Collections.emptySet();
            if (!originalAttrs.containsKey(entry.getKey())) {
                updatedValues.remove("");
                mod.getValuesToBeAdded().addAll(new ArrayList<String>(updatedValues));
                if (virtuals) {
                    result.getVirAttrsToUpdate().add(mod);
                    continue;
                }
                result.getAttrsToUpdate().add(mod);
                continue;
            }
            if (updatedValues.equals(originalValues)) continue;
            updatedValues.remove("");
            if (!entry.getValue().isReadonly()) {
                mod.getValuesToBeAdded().addAll(updatedValues);
                if (!mod.isEmpty()) {
                    if (virtuals) {
                        result.getVirAttrsToRemove().add(mod.getSchema());
                    } else {
                        result.getAttrsToRemove().add(mod.getSchema());
                    }
                }
            }
            mod.getValuesToBeRemoved().addAll(originalValues);
            if (mod.isEmpty()) continue;
            if (virtuals) {
                result.getVirAttrsToUpdate().add(mod);
                continue;
            }
            result.getAttrsToUpdate().add(mod);
        }
    }

    private static void diff(AbstractAttributableTO updated, AbstractAttributableTO original, AbstractAttributableMod result, boolean incremental) {
        if (!(result instanceof MembershipMod) && updated.getId() != original.getId()) {
            throw new IllegalArgumentException("AttributableTO's id must be the same");
        }
        result.setId(updated.getId());
        Map<String, AttributeTO> updatedAttrs = new HashMap<String, AttributeTO>(updated.getAttrMap());
        Map<String, AttributeTO> originalAttrs = new HashMap<String, AttributeTO>(original.getAttrMap());
        HashSet<Object> originalAttrNames = new HashSet(originalAttrs.keySet());
        originalAttrNames.removeAll(updatedAttrs.keySet());
        if (!incremental) {
            result.getAttrsToRemove().clear();
            result.getAttrsToRemove().addAll(originalAttrNames);
        }
        HashSet emptyUpdatedAttrs = new HashSet();
        for (Map.Entry entry : updatedAttrs.entrySet()) {
            if (((AttributeTO)entry.getValue()).getValues() != null && !((AttributeTO)entry.getValue()).getValues().isEmpty()) continue;
            emptyUpdatedAttrs.add(entry.getKey());
        }
        for (String emptyUpdatedAttr : emptyUpdatedAttrs) {
            updatedAttrs.remove(emptyUpdatedAttr);
            result.getAttrsToRemove().add(emptyUpdatedAttr);
        }
        AttributableOperations.populate(updatedAttrs, originalAttrs, result);
        updatedAttrs = updated.getDerAttrMap();
        originalAttrs = original.getDerAttrMap();
        originalAttrNames = new HashSet<String>(originalAttrs.keySet());
        originalAttrNames.removeAll(updatedAttrs.keySet());
        if (!incremental) {
            result.getDerAttrsToRemove().clear();
            result.getDerAttrsToRemove().addAll(originalAttrNames);
        }
        HashSet<String> updatedAttrNames = new HashSet<String>(updatedAttrs.keySet());
        updatedAttrNames.removeAll(originalAttrs.keySet());
        result.getDerAttrsToAdd().clear();
        result.getDerAttrsToAdd().addAll(updatedAttrNames);
        updatedAttrs = updated.getVirAttrMap();
        originalAttrs = original.getVirAttrMap();
        originalAttrNames = new HashSet<String>(originalAttrs.keySet());
        originalAttrNames.removeAll(updatedAttrs.keySet());
        if (!incremental) {
            result.getVirAttrsToRemove().clear();
            result.getVirAttrsToRemove().addAll(originalAttrNames);
        }
        AttributableOperations.populate(updatedAttrs, originalAttrs, result, true);
        if (original instanceof AbstractSubjectTO && updated instanceof AbstractSubjectTO && result instanceof AbstractSubjectMod) {
            HashSet<String> updatedRes = new HashSet<String>(((AbstractSubjectTO)updated).getResources());
            HashSet<String> originalRes = new HashSet<String>(((AbstractSubjectTO)original).getResources());
            updatedRes.removeAll(originalRes);
            ((AbstractSubjectMod)result).getResourcesToAdd().clear();
            ((AbstractSubjectMod)result).getResourcesToAdd().addAll(updatedRes);
            originalRes.removeAll(((AbstractSubjectTO)updated).getResources());
            if (!incremental) {
                ((AbstractSubjectMod)result).getResourcesToRemove().clear();
                ((AbstractSubjectMod)result).getResourcesToRemove().addAll(originalRes);
            }
        }
    }

    public static UserMod diff(UserTO updated, UserTO original) {
        return AttributableOperations.diff(updated, original, false);
    }

    public static UserMod diff(UserTO updated, UserTO original, boolean incremental) {
        UserMod result = new UserMod();
        AttributableOperations.diff(updated, original, result, incremental);
        if (!(updated.getPassword() == null || original.getPassword() != null && original.getPassword().equals(updated.getPassword()))) {
            result.setPassword(updated.getPassword());
        }
        if (original.getUsername() != null && !original.getUsername().equals(updated.getUsername())) {
            result.setUsername(updated.getUsername());
        }
        result.setSecurityQuestion(0L);
        if (updated.getSecurityQuestion() == null) {
            result.setSecurityQuestion(null);
            result.setSecurityAnswer(null);
        } else if (!updated.getSecurityQuestion().equals(original.getSecurityQuestion()) || StringUtils.isNotBlank((CharSequence)updated.getSecurityAnswer())) {
            result.setSecurityQuestion(updated.getSecurityQuestion());
            result.setSecurityAnswer(updated.getSecurityAnswer());
        }
        Map<Long, MembershipTO> updatedMembs = updated.getMembershipMap();
        Map<Long, MembershipTO> originalMembs = original.getMembershipMap();
        for (Map.Entry<Long, MembershipTO> entry : updatedMembs.entrySet()) {
            MembershipMod membMod = new MembershipMod();
            membMod.setRole(entry.getValue().getRoleId());
            if (originalMembs.containsKey(entry.getKey())) {
                if (entry.getValue().equals(originalMembs.get(entry.getKey()))) {
                    membMod.setRole(0L);
                } else {
                    AttributableOperations.diff(entry.getValue(), originalMembs.get(entry.getKey()), membMod, false);
                }
            } else {
                AttributeMod attrMod;
                for (AttributeTO attr : entry.getValue().getAttrs()) {
                    attrMod = new AttributeMod();
                    attrMod.setSchema(attr.getSchema());
                    attrMod.getValuesToBeAdded().addAll(attr.getValues());
                    if (attrMod.isEmpty()) continue;
                    membMod.getAttrsToUpdate().add(attrMod);
                    membMod.getAttrsToRemove().add(attrMod.getSchema());
                }
                for (AttributeTO attr : entry.getValue().getDerAttrs()) {
                    membMod.getDerAttrsToAdd().add(attr.getSchema());
                }
                for (AttributeTO attr : entry.getValue().getVirAttrs()) {
                    attrMod = new AttributeMod();
                    attrMod.setSchema(attr.getSchema());
                    attrMod.getValuesToBeAdded().addAll(attr.getValues());
                    if (attrMod.isEmpty()) continue;
                    membMod.getVirAttrsToUpdate().add(attrMod);
                    membMod.getAttrsToRemove().add(attrMod.getSchema());
                }
            }
            if (membMod.isEmpty()) continue;
            result.getMembershipsToAdd().add(membMod);
        }
        if (!incremental) {
            HashSet<Long> originalRoles = new HashSet<Long>(originalMembs.keySet());
            originalRoles.removeAll(updatedMembs.keySet());
            for (Long roleId : originalRoles) {
                result.getMembershipsToRemove().add(originalMembs.get(roleId).getId());
            }
        }
        return result;
    }

    public static RoleMod diff(RoleTO updated, RoleTO original) {
        return AttributableOperations.diff(updated, original, false);
    }

    public static RoleMod diff(RoleTO updated, RoleTO original, boolean incremental) {
        HashSet<String> originalEnts;
        HashSet<String> updatedEnts;
        RoleMod result = new RoleMod();
        AttributableOperations.diff(updated, original, result, incremental);
        result.setInheritOwner(updated.isInheritOwner());
        result.setInheritTemplates(updated.isInheritTemplates());
        result.setInheritAccountPolicy(updated.isInheritAccountPolicy());
        result.setInheritPasswordPolicy(updated.isInheritPasswordPolicy());
        result.setInheritAttributes(updated.isInheritAttrs());
        result.setInheritDerAttrs(updated.isInheritDerAttrs());
        result.setInheritVirAttrs(updated.isInheritVirAttrs());
        result.setAccountPolicy(new ReferenceMod(updated.getAccountPolicy()));
        result.setPasswordPolicy(new ReferenceMod(updated.getPasswordPolicy()));
        if (!original.getName().equals(updated.getName())) {
            result.setName(updated.getName());
        }
        if ((updatedEnts = new HashSet<String>(updated.getEntitlements())).equals(originalEnts = new HashSet<String>(original.getEntitlements()))) {
            result.setModEntitlements(false);
            result.getEntitlements().clear();
        } else {
            result.setModEntitlements(true);
            result.getEntitlements().addAll(updated.getEntitlements());
        }
        HashSet<String> updatedTemplates = new HashSet<String>(updated.getRAttrTemplates());
        HashSet<String> originalTemplates = new HashSet<String>(original.getRAttrTemplates());
        if (updatedTemplates.equals(originalTemplates)) {
            result.setModRAttrTemplates(false);
            result.getRAttrTemplates().clear();
        } else {
            result.setModRAttrTemplates(true);
            result.getRAttrTemplates().addAll(updated.getRAttrTemplates());
        }
        updatedTemplates = new HashSet<String>(updated.getRDerAttrTemplates());
        originalTemplates = new HashSet<String>(original.getRDerAttrTemplates());
        if (updatedTemplates.equals(originalTemplates)) {
            result.setModRDerAttrTemplates(false);
            result.getRDerAttrTemplates().clear();
        } else {
            result.setModRDerAttrTemplates(true);
            result.getRDerAttrTemplates().addAll(updated.getRDerAttrTemplates());
        }
        updatedTemplates = new HashSet<String>(updated.getRVirAttrTemplates());
        originalTemplates = new HashSet<String>(original.getRVirAttrTemplates());
        if (updatedTemplates.equals(originalTemplates)) {
            result.setModRVirAttrTemplates(false);
            result.getRVirAttrTemplates().clear();
        } else {
            result.setModRVirAttrTemplates(true);
            result.getRVirAttrTemplates().addAll(updated.getRVirAttrTemplates());
        }
        updatedTemplates = new HashSet<String>(updated.getMAttrTemplates());
        originalTemplates = new HashSet<String>(original.getMAttrTemplates());
        if (updatedTemplates.equals(originalTemplates)) {
            result.setModMAttrTemplates(false);
            result.getMAttrTemplates().clear();
        } else {
            result.setModMAttrTemplates(true);
            result.getMAttrTemplates().addAll(updated.getMAttrTemplates());
        }
        updatedTemplates = new HashSet<String>(updated.getMDerAttrTemplates());
        originalTemplates = new HashSet<String>(original.getMDerAttrTemplates());
        if (updatedTemplates.equals(originalTemplates)) {
            result.setModMDerAttrTemplates(false);
            result.getMDerAttrTemplates().clear();
        } else {
            result.setModMDerAttrTemplates(true);
            result.getMDerAttrTemplates().addAll(updated.getMDerAttrTemplates());
        }
        updatedTemplates = new HashSet<String>(updated.getMVirAttrTemplates());
        originalTemplates = new HashSet<String>(original.getMVirAttrTemplates());
        if (updatedTemplates.equals(originalTemplates)) {
            result.setModMVirAttrTemplates(false);
            result.getMVirAttrTemplates().clear();
        } else {
            result.setModMVirAttrTemplates(true);
            result.getMVirAttrTemplates().addAll(updated.getMVirAttrTemplates());
        }
        result.setUserOwner(new ReferenceMod(updated.getUserOwner()));
        result.setRoleOwner(new ReferenceMod(updated.getRoleOwner()));
        return result;
    }

    private static List<AttributeTO> getUpdateValues(Map<String, AttributeTO> attrs, Set<String> attrsToBeRemoved, Set<AttributeMod> attrsToBeUpdated) {
        HashMap<String, AttributeTO> rwattrs = new HashMap<String, AttributeTO>(attrs);
        for (String attrName : attrsToBeRemoved) {
            rwattrs.remove(attrName);
        }
        for (AttributeMod attrMod : attrsToBeUpdated) {
            AttributeTO attrTO;
            if (rwattrs.containsKey(attrMod.getSchema())) {
                attrTO = (AttributeTO)rwattrs.get(attrMod.getSchema());
                attrTO.getValues().removeAll(attrMod.getValuesToBeRemoved());
                attrTO.getValues().addAll(attrMod.getValuesToBeAdded());
                continue;
            }
            attrTO = new AttributeTO();
            attrTO.setSchema(attrMod.getSchema());
            attrTO.getValues().addAll(attrMod.getValuesToBeAdded());
            rwattrs.put(attrMod.getSchema(), attrTO);
        }
        return new ArrayList<AttributeTO>(rwattrs.values());
    }

    private static <T extends AbstractAttributableTO, K extends AbstractAttributableMod> void apply(T to, K mod, T result) {
        result.getAttrs().addAll(AttributableOperations.getUpdateValues(to.getAttrMap(), mod.getAttrsToRemove(), mod.getAttrsToUpdate()));
        Map<String, AttributeTO> attrs = to.getDerAttrMap();
        for (String attrName : mod.getDerAttrsToRemove()) {
            attrs.remove(attrName);
        }
        for (String attrName : mod.getDerAttrsToAdd()) {
            AttributeTO attrTO = new AttributeTO();
            attrTO.setSchema(attrName);
            attrs.put(attrName, attrTO);
        }
        result.getDerAttrs().addAll(attrs.values());
        result.getVirAttrs().addAll(AttributableOperations.getUpdateValues(to.getVirAttrMap(), mod.getVirAttrsToRemove(), mod.getVirAttrsToUpdate()));
        if (result instanceof AbstractSubjectTO && mod instanceof AbstractSubjectMod) {
            ((AbstractSubjectTO)result).getResources().removeAll(((AbstractSubjectMod)mod).getResourcesToRemove());
            ((AbstractSubjectTO)result).getResources().addAll(((AbstractSubjectMod)mod).getResourcesToAdd());
        }
    }

    public static UserTO apply(UserTO userTO, UserMod userMod) {
        if (userTO.getId() != userMod.getId()) {
            throw new IllegalArgumentException("UserTO and UserMod ids must be the same");
        }
        UserTO result = (UserTO)SerializationUtils.clone((Serializable)userTO);
        AttributableOperations.apply(userTO, userMod, result);
        result.setPassword(userMod.getPassword());
        if (userMod.getUsername() != null) {
            result.setUsername(userMod.getUsername());
        }
        Map<Long, MembershipTO> membs = result.getMembershipMap();
        for (Long membId : userMod.getMembershipsToRemove()) {
            result.getMemberships().remove(membs.get(membId));
        }
        for (MembershipMod membMod : userMod.getMembershipsToAdd()) {
            MembershipTO membTO = new MembershipTO();
            membTO.setRoleId(membMod.getRole());
            AttributableOperations.apply(membTO, membMod, membTO);
        }
        return result;
    }
}

