/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.ValuedDataObject;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;

public class SubProcessJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        SubProcessJsonConverter.fillJsonTypes(convertersToBpmnMap);
        SubProcessJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("SubProcess", SubProcessJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(SubProcess.class, SubProcessJsonConverter.class);
    }

    @Override
    protected String getStencilId(FlowElement flowElement) {
        return "SubProcess";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, FlowElement flowElement) {
        SubProcess subProcess = (SubProcess)flowElement;
        propertiesNode.put("activitytype", "Sub-Process");
        propertiesNode.put("subprocesstype", "Embedded");
        ArrayNode subProcessShapesArrayNode = this.objectMapper.createArrayNode();
        GraphicInfo graphicInfo = this.model.getGraphicInfo(flowElement.getId());
        this.processor.processFlowElements(subProcess.getFlowElements(), this.model, subProcessShapesArrayNode, graphicInfo.getX(), graphicInfo.getY());
        this.flowElementNode.put("childShapes", (JsonNode)subProcessShapesArrayNode);
        new BpmnJsonConverter().convertDataPropertiesToJson(subProcess.getDataObjects(), propertiesNode);
    }

    @Override
    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        SubProcess subProcess = new SubProcess();
        JsonNode childShapesArray = elementNode.get("childShapes");
        this.processor.processJsonElements(childShapesArray, modelNode, (BaseElement)subProcess, shapeMap);
        JsonNode processDataPropertiesNode = elementNode.get("properties").get("dataproperties");
        if (processDataPropertiesNode != null) {
            List<ValuedDataObject> dataObjects = new BpmnJsonConverter().convertJsonToDataProperties(processDataPropertiesNode, (BaseElement)subProcess);
            subProcess.setDataObjects(dataObjects);
            subProcess.getFlowElements().addAll(dataObjects);
        }
        return subProcess;
    }
}

