/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.template;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.core.util.resource.locator.ResourceStreamLocator;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;
import org.apache.wicket.util.template.TextTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageTextTemplate
extends TextTemplate {
    private static final Logger log = LoggerFactory.getLogger(PackageTextTemplate.class);
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_CONTENT_TYPE = "text";
    public static final String DEFAULT_ENCODING = null;
    private final StringBuilder buffer = new StringBuilder();

    public PackageTextTemplate(Class<?> clazz, String fileName) {
        this(clazz, fileName, DEFAULT_CONTENT_TYPE);
    }

    public PackageTextTemplate(Class<?> clazz, String fileName, String contentType) {
        this(clazz, fileName, contentType, DEFAULT_ENCODING);
    }

    public PackageTextTemplate(Class<?> clazz, String fileName, String contentType, String encoding) {
        this(clazz, fileName, null, null, null, contentType, encoding);
    }

    public PackageTextTemplate(Class<?> clazz, String fileName, String style, String variation, Locale locale, String contentType, String encoding) {
        super(contentType);
        String path = Packages.absolutePath(clazz, (String)fileName);
        Application app = Application.get();
        IResourceStream stream = app.getResourceSettings().getResourceStreamLocator().locate(clazz, path, style, variation, locale, null, false);
        if (stream == null) {
            stream = new ResourceStreamLocator().locate(clazz, path, style, variation, locale, null, false);
        }
        if (stream == null) {
            throw new IllegalArgumentException("resource " + fileName + " not found for scope " + clazz + " (path = " + path + ")");
        }
        this.setLastModified(stream.lastModifiedTime());
        try {
            if (encoding != null) {
                this.buffer.append(Streams.readString((InputStream)stream.getInputStream(), (CharSequence)encoding));
            } else {
                this.buffer.append(Streams.readString((InputStream)stream.getInputStream()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ResourceStreamNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public String getString() {
        return this.buffer.toString();
    }

    @Override
    public final TextTemplate interpolate(Map<String, ?> variables) {
        if (variables != null) {
            String result = new MapVariableInterpolator(this.buffer.toString(), variables).toString();
            this.buffer.delete(0, this.buffer.length());
            this.buffer.append(result);
        }
        return this;
    }
}

