/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.search;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.common.types.SubjectType;

public class SearchableFields {
    protected static final String[] ATTRIBUTES_NOTINCLUDED = new String[]{"attrs", "derAttrs", "virAttrs", "serialVersionUID", "memberships", "entitlements", "resources", "password", "propagationTOs", "propagationStatusMap", "securityAnswer", "token", "tokenExpireTime"};

    public static final List<String> get(SubjectType subjectType) {
        return SearchableFields.get(subjectType == SubjectType.USER ? UserTO.class : RoleTO.class);
    }

    public static final List<String> get(Class<? extends AbstractAttributableTO> attributableRef) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Class<? extends AbstractAttributableTO> clazz = attributableRef; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (ArrayUtils.contains((Object[])ATTRIBUTES_NOTINCLUDED, (Object)field.getName())) continue;
                fieldNames.add(field.getName());
            }
        }
        Collections.reverse(fieldNames);
        return fieldNames;
    }

    private SearchableFields() {
    }
}

