/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.xml;

import org.apache.ibatis.builder.IncompleteElementException;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.parsing.PropertyParser;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.session.Configuration;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLIncludeTransformer {
    private final Configuration configuration;
    private final MapperBuilderAssistant builderAssistant;

    public XMLIncludeTransformer(Configuration configuration, MapperBuilderAssistant builderAssistant) {
        this.configuration = configuration;
        this.builderAssistant = builderAssistant;
    }

    public void applyIncludes(Node source) {
        if (source.getNodeName().equals("include")) {
            Node toInclude = this.findSqlFragment(this.getStringAttribute(source, "refid"));
            this.applyIncludes(toInclude);
            if (toInclude.getOwnerDocument() != source.getOwnerDocument()) {
                toInclude = source.getOwnerDocument().importNode(toInclude, true);
            }
            source.getParentNode().replaceChild(toInclude, source);
            while (toInclude.hasChildNodes()) {
                toInclude.getParentNode().insertBefore(toInclude.getFirstChild(), toInclude);
            }
            toInclude.getParentNode().removeChild(toInclude);
        } else if (source.getNodeType() == 1) {
            NodeList children = source.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.applyIncludes(children.item(i));
            }
        }
    }

    private Node findSqlFragment(String refid) {
        refid = PropertyParser.parse(refid, this.configuration.getVariables());
        refid = this.builderAssistant.applyCurrentNamespace(refid, true);
        try {
            XNode nodeToInclude = this.configuration.getSqlFragments().get(refid);
            Node result = nodeToInclude.getNode().cloneNode(true);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new IncompleteElementException("Could not find SQL statement to include with refid '" + refid + "'", e);
        }
    }

    private String getStringAttribute(Node node, String name) {
        return node.getAttributes().getNamedItem(name).getNodeValue();
    }
}

