/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.installer.validators;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import java.sql.Driver;
import java.util.Properties;
import org.apache.syncope.installer.enums.DBs;
import org.apache.syncope.installer.utilities.DriverLoader;
import org.apache.syncope.installer.validators.AbstractValidator;

public class PersistenceValidator
extends AbstractValidator {
    private String persistenceUrl;
    private String persistenceDbuser;
    private String persistenceDbPassword;
    private StringBuilder error;
    private StringBuilder warning;
    private boolean isProxyEnabled;
    private String proxyHost;
    private String proxyPort;
    private String proxyUser;
    private String proxyPwd;

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        DBs selectedDB = DBs.fromDbName(installData.getVariable("install.type.selection"));
        this.persistenceUrl = installData.getVariable("persistence.url");
        this.persistenceDbuser = installData.getVariable("persistence.dbuser");
        this.persistenceDbPassword = installData.getVariable("persistence.dbpassword");
        this.isProxyEnabled = Boolean.valueOf(installData.getVariable("mvn.proxy"));
        this.proxyHost = installData.getVariable("mvn.proxy.host");
        this.proxyPort = installData.getVariable("mvn.proxy.port");
        this.proxyUser = installData.getVariable("mvn.proxy.user");
        this.proxyPwd = installData.getVariable("mvn.proxy.pwd");
        boolean verified = true;
        this.error = new StringBuilder("Required fields:\n");
        if (this.isEmpty(this.persistenceUrl)) {
            this.error.append("Persistence URL\n");
            verified = false;
        }
        if (this.isEmpty(this.persistenceDbuser)) {
            this.error.append("Persistence user\n");
            verified = false;
        }
        if (this.isEmpty(this.persistenceDbPassword)) {
            this.error.append("Persistence password\n");
            verified = false;
        }
        if (!verified) {
            return DataValidator.Status.ERROR;
        }
        switch (selectedDB) {
            case POSTGRES: 
            case MYSQL: 
            case MARIADB: {
                return this.checkConnection(selectedDB);
            }
            case SQLSERVER: {
                this.warning = new StringBuilder("Remember to check your SqlServer db connection");
                return DataValidator.Status.WARNING;
            }
            case ORACLE: {
                this.warning = new StringBuilder("Remember to check your Oracle db connection");
                return DataValidator.Status.WARNING;
            }
        }
        this.error = new StringBuilder("DB not supported yet");
        return DataValidator.Status.ERROR;
    }

    private DataValidator.Status checkConnection(DBs selectedDb) {
        Driver driver = null;
        try {
            driver = DriverLoader.load(selectedDb, this.isProxyEnabled, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPwd);
            Properties props = new Properties();
            props.put("user", this.persistenceDbuser);
            props.put("password", this.persistenceDbPassword);
            driver.connect(this.persistenceUrl, props);
            return DataValidator.Status.OK;
        }
        catch (Exception ex) {
            this.error = new StringBuilder("Error during connection to database: please check inserted data.");
            this.error.append(driver == null ? " Unable to get " + selectedDb.getName() + " driver!" : "");
            return DataValidator.Status.ERROR;
        }
    }

    @Override
    public String getErrorMessageId() {
        return this.error.toString();
    }

    @Override
    public String getWarningMessageId() {
        return this.warning.toString();
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }
}

