/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.installer.validators;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import java.io.File;
import org.apache.syncope.installer.enums.Containers;
import org.apache.syncope.installer.utilities.HttpUtils;
import org.apache.syncope.installer.validators.AbstractValidator;

public class ContainerValidator
extends AbstractValidator {
    private StringBuilder error;

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        Containers selectedContainer = Containers.fromContainerName(installData.getVariable("install.container.selection"));
        String tomcatSsl = installData.getVariable("tomcat.container.ssl");
        String tomcatHost = installData.getVariable("tomcat.container.host");
        String tomcatPort = installData.getVariable("tomcat.container.port");
        String tomcatUser = installData.getVariable("tomcat.container.user");
        String tomcatPassword = installData.getVariable("tomcat.container.pwd");
        String glassfishDir = installData.getVariable("glassfish.container.dir");
        String jbossSsl = installData.getVariable("jboss.container.ssl");
        String jbossHost = installData.getVariable("jboss.container.host");
        String jbossPort = installData.getVariable("jboss.container.port");
        String jbossJdbcModule = installData.getVariable("jboss.container.jdbc.module");
        String jbossAdminUsername = installData.getVariable("jboss.container.user");
        String jbossAdminPassword = installData.getVariable("jboss.container.pwd");
        switch (selectedContainer) {
            case TOMCAT: {
                boolean verified = true;
                this.error = new StringBuilder("Required fields:\n");
                if (this.isEmpty(tomcatHost)) {
                    this.error.append("Tomcat host\n");
                    verified = false;
                }
                if (this.isEmpty(tomcatPort)) {
                    this.error.append("Tomcat port\n");
                    verified = false;
                }
                if (this.isEmpty(tomcatUser)) {
                    this.error.append("Tomcat user\n");
                    verified = false;
                }
                if (this.isEmpty(tomcatPassword)) {
                    this.error.append("Tomcat password\n");
                    verified = false;
                }
                if (!verified) {
                    return DataValidator.Status.ERROR;
                }
                int responseCode = HttpUtils.ping(Boolean.valueOf(tomcatSsl), tomcatHost, tomcatPort);
                if (responseCode == 200) {
                    return DataValidator.Status.OK;
                }
                this.error = new StringBuilder("Tomcat URL is offline");
                return DataValidator.Status.ERROR;
            }
            case JBOSS: {
                boolean virified = true;
                this.error = new StringBuilder("Required fields:\n");
                if (this.isEmpty(jbossHost)) {
                    this.error.append("JBoss Host\n");
                    virified = false;
                }
                if (this.isEmpty(jbossPort)) {
                    this.error.append("JBoss Port\n");
                    virified = false;
                }
                if (this.isEmpty(jbossJdbcModule)) {
                    this.error.append("JBoss JDBC module name\n");
                    virified = false;
                }
                if (this.isEmpty(jbossAdminUsername)) {
                    this.error.append("JBoss admin username\n");
                    virified = false;
                }
                if (this.isEmpty(jbossAdminPassword)) {
                    this.error.append("JBoss admin password\n");
                    virified = false;
                }
                if (!virified) {
                    return DataValidator.Status.ERROR;
                }
                int jResponseCode = HttpUtils.ping(Boolean.valueOf(jbossSsl), jbossHost, jbossPort);
                if (jResponseCode == 200) {
                    return DataValidator.Status.OK;
                }
                this.error = new StringBuilder("JBoss URL is offline");
                return DataValidator.Status.ERROR;
            }
            case GLASSFISH: {
                this.error = new StringBuilder("Required fields:\n");
                if (this.isEmpty(glassfishDir)) {
                    this.error.append("Glassfish directory\n");
                    return DataValidator.Status.ERROR;
                }
                File dir = new File(glassfishDir);
                if (!dir.exists()) {
                    this.error.append("Glassfish directory not found");
                    return DataValidator.Status.ERROR;
                }
                if (!dir.isDirectory()) {
                    this.error.append("Glassfish directory is not a directory");
                    return DataValidator.Status.ERROR;
                }
                return DataValidator.Status.OK;
            }
        }
        this.error = new StringBuilder("Container not supported yet");
        return DataValidator.Status.ERROR;
    }

    @Override
    public String getErrorMessageId() {
        return this.error.toString();
    }

    @Override
    public String getWarningMessageId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean getDefaultAnswer() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

